/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.rest.exceptions.AuthenticationException;
import de.sep.sesam.rest.exceptions.CliCommonErrorException;
import de.sep.sesam.rest.exceptions.ConnectionException;
import de.sep.sesam.rest.exceptions.IllegalParameterException;
import de.sep.sesam.rest.exceptions.InvalidValueException;
import de.sep.sesam.rest.exceptions.NotEditableException;
import de.sep.sesam.rest.exceptions.ObjectInUseException;
import de.sep.sesam.rest.exceptions.ObjectNotFoundException;
import de.sep.sesam.rest.exceptions.OperationNotPossibleException;
import de.sep.sesam.rest.exceptions.ServiceException;
import de.sep.sesam.rest.utils.ErrorType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import lombok.Generated;

@JsonDeserialize(builder=RestErrorBuilder.class)
@Schema(description="The error object returned by the REST API.")
public class RestError
extends AbstractSerializableObject {
    @JsonIgnore
    private static final long serialVersionUID = -3551013759696319778L;
    @Schema(description="The error code.", example="error")
    private String error;
    @Schema(description="The error message.", example="The error message.")
    private String message;
    @Schema(description="The error parameter.", example="The error parameter.")
    private String[] parameter;
    @Schema(description="The error type.", example="OBJECT_NOT_FOUND")
    private ErrorType type;
    @Schema(description="The error url.", example="http://localhost:8080/sep-rest-api/v1/object/1234567890")
    private String url;

    public ServiceException toServiceException() {
        if (this.type == null) {
            return new OperationNotPossibleException(OperationNotPossibleException.ONPMessage.INVALID_ACTION, this, "");
        }
        switch (this.type) {
            case AUTHENTICATION: {
                return AuthenticationException.fromError(this);
            }
            case CONNECTION: {
                return ConnectionException.fromError(this);
            }
            case ILLEGAL_PARAMETER: {
                return IllegalParameterException.fromError(this);
            }
            case INVALID_VALUE: {
                return InvalidValueException.fromError(this);
            }
            case NOT_EDITABLE: {
                return NotEditableException.fromError(this);
            }
            case OBJECT_IN_USE: {
                return ObjectInUseException.fromError(this);
            }
            case OBJECT_NOT_FOUND: {
                return ObjectNotFoundException.fromError(this);
            }
            case OPERATION_NOT_POSSIBLE: {
                return OperationNotPossibleException.fromError(this);
            }
            case CLI_COMMON_ERROR: {
                return CliCommonErrorException.fromError(this);
            }
        }
        return new OperationNotPossibleException(OperationNotPossibleException.ONPMessage.INVALID_ACTION, this, "");
    }

    @Generated
    RestError(String error, String message, String[] parameter, ErrorType type, String url) {
        this.error = error;
        this.message = message;
        this.parameter = parameter;
        this.type = type;
        this.url = url;
    }

    @Generated
    public static RestErrorBuilder builder() {
        return new RestErrorBuilder();
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String[] getParameter() {
        return this.parameter;
    }

    @Generated
    public ErrorType getType() {
        return this.type;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public static class RestErrorBuilder {
        @Generated
        private String error;
        @Generated
        private String message;
        @Generated
        private String[] parameter;
        @Generated
        private ErrorType type;
        @Generated
        private String url;

        @Generated
        RestErrorBuilder() {
        }

        @Generated
        public RestErrorBuilder withError(String error) {
            this.error = error;
            return this;
        }

        @Generated
        public RestErrorBuilder withMessage(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public RestErrorBuilder withParameter(String[] parameter) {
            this.parameter = parameter;
            return this;
        }

        @Generated
        public RestErrorBuilder withType(ErrorType type) {
            this.type = type;
            return this;
        }

        @Generated
        public RestErrorBuilder withUrl(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public RestError build() {
            return new RestError(this.error, this.message, this.parameter, this.type, this.url);
        }

        @Generated
        public String toString() {
            return "RestError.RestErrorBuilder(error=" + this.error + ", message=" + this.message + ", parameter=" + Arrays.deepToString(this.parameter) + ", type=" + this.type + ", url=" + this.url + ")";
        }
    }
}

