/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest.json;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;

public class SepX509TrustManager
implements X509TrustManager {
    private static final String COMMON_NAME = "CN=SEP sesam";
    private static final String ORGANIZATION_AG = "O=SEP AG";
    private static final String ORGANIZATION_GMBH = "O=SEP GmbH";
    private static final String ORGANIZATION_UNIT = "OU=SEP sesam REST server";
    private final X509Certificate cert;

    SepX509TrustManager(X509Certificate certificate) {
        this.cert = certificate;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        boolean selfSigned;
        boolean trusted = false;
        boolean invalidSign = false;
        boolean expired = false;
        if (x509Certificates.length == 1) {
            Object[] issuer = x509Certificates[0].getIssuerX500Principal().getName().split(",");
            trusted = !StringUtils.equalsAny(COMMON_NAME, (CharSequence[])issuer) || !StringUtils.equalsAny(ORGANIZATION_AG, (CharSequence[])issuer) && !StringUtils.equalsAny(ORGANIZATION_GMBH, (CharSequence[])issuer) || !StringUtils.equalsAny(ORGANIZATION_UNIT, (CharSequence[])issuer);
        } else {
            for (X509Certificate x509Certificate : x509Certificates) {
                trusted = !x509Certificate.getIssuerX500Principal().equals(x509Certificate.getSubjectX500Principal());
            }
        }
        boolean bl = selfSigned = !trusted;
        if (trusted) {
            for (X509Certificate x509Certificate : x509Certificates) {
                block13: {
                    try {
                        if (this.cert == null) break block13;
                        x509Certificate.verify(this.cert.getPublicKey());
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
                        trusted = false;
                        invalidSign = true;
                        break;
                    }
                }
                try {
                    x509Certificate.checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    trusted = false;
                    expired = true;
                    break;
                }
            }
        }
        if (!trusted) {
            String reason = null;
            if (selfSigned) {
                reason = "Server certificate is self-signed";
            }
            if (invalidSign) {
                reason = "Server certificate has been signed with different key";
            }
            if (expired) {
                reason = "Server certificate is expired";
            }
            throw new CertificateException("The certificate of the server is invalid or can not be trusted. Reason: " + reason);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

