/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest.json;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.http.ssl.TrustStrategy;

public class SepCertTrustStrategy
implements TrustStrategy {
    private final X509Certificate cert;

    SepCertTrustStrategy(X509Certificate certificate) {
        this.cert = certificate;
    }

    @Override
    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean trusted = false;
        if (chain.length == 1) {
            trusted = !chain[0].getIssuerX500Principal().equals(chain[0].getSubjectX500Principal());
        } else {
            for (X509Certificate crt : chain) {
                trusted = !crt.getIssuerX500Principal().equals(crt.getSubjectX500Principal());
            }
        }
        if (trusted) {
            try {
                for (X509Certificate crt : chain) {
                    if (this.cert != null) {
                        crt.verify(this.cert.getPublicKey());
                    }
                    crt.checkValidity();
                }
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
                trusted = false;
            }
        }
        return trusted;
    }
}

