/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest.json;

import de.sep.sesam.common.json.JsonUtil;
import de.sep.sesam.rest.utils.RestError;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;

public class JsonResult {
    private static final ContentType TEXT_PLAIN = ContentType.create("text/plain", Consts.UTF_8);
    public String result;
    public RestError restError = null;
    public byte[] bres;
    public ContentType contentType;

    public <T> T read(Class<T> modelClass) throws IOException {
        assert (modelClass != null);
        if (this.result != null) {
            if (TEXT_PLAIN.equals(this.contentType)) {
                System.out.println(new String(this.bres, "UTF-8"));
                return null;
            }
            return JsonUtil.read(this.result, modelClass);
        }
        return null;
    }

    public <T> List<T> readList(Class<T> modelClass) throws IOException {
        if (this.result != null) {
            if (TEXT_PLAIN.equals(this.contentType)) {
                System.out.println(new String(this.bres, "UTF-8"));
                return null;
            }
            return JsonUtil.readList(this.result, modelClass);
        }
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.contentType != null) {
            buffer.append(this.contentType.toString());
            buffer.append(": ");
        }
        if (TEXT_PLAIN.equals(this.contentType)) {
            try {
                buffer.append(new String(this.bres, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else if (this.result != null) {
            buffer.append(this.result);
        }
        if (this.restError != null) {
            buffer.append(this.restError.toString());
        }
        return buffer.length() > 0 ? buffer.toString() : super.toString();
    }
}

