/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest.json;

import de.sep.sesam.common.json.JsonUtil;
import de.sep.sesam.common.logging.ContextLogger;
import de.sep.sesam.common.logging.HttpMethods;
import de.sep.sesam.common.logging.LogGroup;
import de.sep.sesam.common.logging.LogMessage;
import de.sep.sesam.common.logging.SepLogLevel;
import de.sep.sesam.common.logging.messages.SimpleMessage;
import de.sep.sesam.common.security.CertificateUtils;
import de.sep.sesam.rest.DefaultQueryParameter;
import de.sep.sesam.rest.FileDownloadState;
import de.sep.sesam.rest.RestSession;
import de.sep.sesam.rest.exceptions.ConnectionException;
import de.sep.sesam.rest.interfaces.IQueryParameter;
import de.sep.sesam.rest.json.JsonResult;
import de.sep.sesam.rest.json.SepX509TrustManager;
import de.sep.sesam.rest.utils.ErrorType;
import de.sep.sesam.rest.utils.RestError;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.BufferedHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EncodingUtils;
import org.apache.http.util.EntityUtils;

public class JsonHttpRequest {
    private static final ContextLogger logger = new ContextLogger(JsonHttpRequest.class);
    public static final String DATEFORMAT_HEADER = "X-Sesam-Dateformat";
    public static final String CYCLIC_HEADER = "X-Sesam-Cyclic";
    public static final String TFA_VERIFICATION_CODE = "X-Sesam-Tfa-Code";
    public static final String MULTI_REQUEST = "X-Sesam-Multi";
    public static final String MULTI_CLI_REQUEST = "X-Sesam-CLI-Multi";
    public static final String SESAM_API_KEY = "X-Sesam-Api-Key";
    private static final String SEP_URL = "/sep/api/";
    private final String user;
    private String password;
    private List<String> redirectServers;
    private boolean multiComputingCliRequest;
    private String mfaVerCode;
    private String apiKey;
    private List<IQueryParameter> parameters;
    private static String lastHttpErrorResult;
    private static String lastHttpResult;
    public static boolean debug;
    private boolean keepAlive = true;
    private boolean cyclic;
    private final SepLogLevel logLevel;
    private String sessionId;
    private BufferedHeader certificateAuthHeader;
    private final CloseableHttpClient httpClient;
    private static final ContentType APPLICATION_JSON;
    private static final ContentType BINARY;
    private static final DateTimeFormatter timeFormat;
    private static final Pattern PW_PATTERN;
    public static final String SESSION_HEADER = "X-SEP-Session";

    public static CloseableHttpClient buildHttpClient(boolean singleRequest, int connectTimeout) {
        CloseableHttpClient httpClient = null;
        SSLContextBuilder builder = new SSLContextBuilder();
        assert (builder != null);
        try {
            RequestConfig requestConfig;
            builder.loadTrustMaterial(null, new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)new NoopHostnameVerifier());
            RequestConfig requestConfig2 = requestConfig = connectTimeout > 0 ? RequestConfig.copy(RequestConfig.DEFAULT).setConnectTimeout(connectTimeout * 1000).setContentCompressionEnabled(false).build() : RequestConfig.copy(RequestConfig.DEFAULT).setContentCompressionEnabled(false).build();
            httpClient = singleRequest ? HttpClients.custom().setSSLSocketFactory(sslsf).setDefaultRequestConfig(requestConfig).build() : HttpClients.custom().setMaxConnPerRoute(50).setMaxConnTotal(500).setSSLSocketFactory(sslsf).setDefaultRequestConfig(requestConfig).build();
        }
        catch (Exception e) {
            logger.error("buildHttpClient", LogGroup.ERROR, (LogMessage)new SimpleMessage("Failed to create and to configure the HTTP client instance: {0}"), e.getMessage());
        }
        return httpClient;
    }

    private CloseableHttpClient buildHttpClient(int connectionTimeout, File caFile) {
        CloseableHttpClient httpClient = null;
        try {
            X509Certificate certificate = null;
            if (caFile != null) {
                String original = FileUtils.readFileToString(caFile, Charset.defaultCharset());
                String pemString = CertificateUtils.extractPemString(original);
                if (StringUtils.isNotBlank(pemString)) {
                    byte[] decoded = Base64.decodeBase64(pemString);
                    certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(decoded));
                } else {
                    certificate = null;
                }
            }
            RequestConfig requestConfig = connectionTimeout > 0 ? RequestConfig.copy(RequestConfig.DEFAULT).setConnectTimeout(connectionTimeout * 1000).setContentCompressionEnabled(false).build() : RequestConfig.copy(RequestConfig.DEFAULT).setContentCompressionEnabled(false).build();
            httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setSSLContext(this.context(certificate)).build();
        }
        catch (Exception e) {
            logger.error("buildHttpClient", LogGroup.ERROR, (LogMessage)new SimpleMessage("Failed to create and to configure the HTTP client instance: {0}"), e.getMessage());
        }
        return httpClient;
    }

    private SSLContext context(X509Certificate cert) throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext context = SSLContext.getInstance("TLS");
        SepX509TrustManager trustManager = new SepX509TrustManager(cert);
        TrustManager[] tms = new TrustManager[]{trustManager};
        context.init(null, tms, new SecureRandom());
        return context;
    }

    public JsonHttpRequest(SepLogLevel level, String user, String password, int connectTimeout, String caAuthorityFile) {
        this.user = user;
        this.password = password;
        this.logLevel = level;
        File caFile = null;
        if (!(!StringUtils.isNotBlank(caAuthorityFile) || (caFile = new File(caAuthorityFile)).exists() && caFile.canRead())) {
            caFile = null;
        }
        this.httpClient = this.buildHttpClient(connectTimeout, caFile);
    }

    public JsonHttpRequest(SepLogLevel level, String user, String password, int connectTimeout) {
        assert (level != null);
        this.logLevel = level;
        this.user = user;
        this.password = password;
        this.httpClient = JsonHttpRequest.buildHttpClient(true, connectTimeout);
    }

    public JsonHttpRequest(SepLogLevel level, RestSession session) {
        assert (level != null);
        assert (session != null);
        this.logLevel = level;
        this.httpClient = session.getHttpClient();
        assert (this.httpClient != null);
        this.user = session.getUser();
        this.sessionId = session.getId();
    }

    private String getLocalTime() {
        LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(System.currentTimeMillis()), TimeZone.getDefault().toZoneId());
        return timeFormat.format(ldt);
    }

    public String buildURL(String server, int port, String object, String action) throws IOException {
        assert (server != null);
        assert (object != null);
        String url = "https://" + server + ":" + port;
        url = StringUtils.startsWith(object, "/") ? url + this.encodeLastSegment(object) + (String)(StringUtils.isNotBlank(action) ? "/" + this.encodeSegments(action) : "") : url + SEP_URL + this.encodeLastSegment(object) + (String)(StringUtils.isNotBlank(action) ? "/" + this.encodeSegments(action) : "");
        return this.buildUrlFinal(url);
    }

    private String encodeLastSegment(String input) {
        CharSequence[] array = input.split("/");
        array[array.length - 1] = URLEncoder.encode(array[array.length - 1], StandardCharsets.UTF_8);
        return String.join((CharSequence)"/", array);
    }

    private String encodeSegments(String input) {
        CharSequence[] array = input.split("/");
        for (int i = 0; i < array.length; ++i) {
            array[i] = URLEncoder.encode((String)array[i], StandardCharsets.UTF_8);
        }
        return String.join((CharSequence)"/", array);
    }

    private String buildUrlFinal(String url) throws IOException {
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (!CollectionUtils.isEmpty(this.redirectServers)) {
                if (!this.redirectServers.stream().map(r -> r.split(":")).collect(Collectors.toList()).stream().allMatch(s -> ((String[])s).length == 2)) {
                    throw new IOException("Each redirect server should corresponds redirect port");
                }
                uriBuilder.addParameter("urls", String.join((CharSequence)",", this.redirectServers));
                if (this.redirectServers.size() > 1) {
                    this.multiComputingCliRequest = true;
                }
            }
            if (this.getParameters() != null) {
                ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
                this.getParameters().forEach(p -> params.add(new BasicNameValuePair(p.getName(), p.getValue())));
                uriBuilder.addParameters(params);
            }
            url = uriBuilder.build().toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return url;
    }

    /*
     * Exception decompiling
     */
    public JsonResult downloadV2(String server, int port, Map<String, String> queryParameters, Path localDir, File localFile, boolean overwrite, FileDownloadState state) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getFilenameFromHeader(CloseableHttpResponse response) {
        assert (response != null);
        Header header = response.getFirstHeader("content-disposition");
        String headerValue = header != null ? header.getValue() : null;
        return StringUtils.substring(headerValue, 22, StringUtils.length(headerValue) - 1);
    }

    public JsonResult call(String server, int port, String object, String action, Object postObject, Map<String, byte[]> files) throws IOException {
        MultipartEntityBuilder mep = null;
        if (files != null) {
            mep = MultipartEntityBuilder.create();
            for (String k : files.keySet()) {
                mep.addBinaryBody(k, files.get(k), ContentType.DEFAULT_BINARY, k.replace(":", "**"));
            }
        }
        return this.callInner(server, port, null, object, action, postObject, mep);
    }

    public JsonResult call(String server, int port, HttpMethods httpMethod, String object, String action, Object postObject, Map<String, byte[]> files) throws IOException {
        MultipartEntityBuilder mep = null;
        if (files != null) {
            mep = MultipartEntityBuilder.create();
            for (String k : files.keySet()) {
                mep.addBinaryBody(k, files.get(k), ContentType.DEFAULT_BINARY, k);
            }
        }
        return this.callInner(server, port, httpMethod, object, action, postObject, mep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonResult callInner(String server, int port, HttpMethods httpMethod, String object, String action, Object postObject, MultipartEntityBuilder mep) throws IOException {
        CloseableHttpResponse response;
        HttpRequestBase httpRequest;
        String method = "call";
        assert (this.httpClient != null);
        String url = null;
        if (postObject != null && httpMethod == null || HttpMethods.POST.equals((Object)httpMethod)) {
            url = this.buildURL(server, port, object, action);
            HttpPost postRequest = new HttpPost(url);
            httpRequest = postRequest;
            if (mep != null) {
                mep.addTextBody("data", JsonUtil.getString(postObject), ContentType.APPLICATION_JSON);
                postRequest.setEntity(mep.build());
            } else {
                String body = JsonUtil.getString(postObject);
                StringEntity requestEntity = new StringEntity(Base64.encodeBase64URLSafeString(body.getBytes(StandardCharsets.UTF_8)));
                requestEntity.setContentType("application/json; base64");
                postRequest.setEntity(requestEntity);
            }
            if ((debug || this.logLevel.is(SepLogLevel.TRACE)) && !this.cyclic) {
                String time = this.getLocalTime();
                System.err.println(time + " POST " + url + " JSON");
                System.err.println(this.maskPassword(JsonUtil.getString(postObject)));
                System.err.println("-----");
            }
        } else {
            httpRequest = null;
            if (HttpMethods.DELETE.equals((Object)httpMethod)) {
                if (!(postObject instanceof String) && !(postObject instanceof Long)) {
                    throw new IOException("ID of the object for delete method should be Long or String");
                }
                url = this.buildURL(server, port, object, postObject.toString());
                httpRequest = new HttpDelete(url);
            }
            if (httpRequest == null) {
                url = this.buildURL(server, port, object, action);
                httpRequest = new HttpGet(url);
            }
            httpRequest.setHeader("Content-Type", APPLICATION_JSON.getMimeType());
            if ((debug || this.logLevel.is(SepLogLevel.TRACE)) && !this.cyclic) {
                String time = this.getLocalTime();
                System.err.println(time + " " + httpRequest.getMethod() + " " + url);
                System.err.println("-----");
            }
        }
        if (this.isCyclic()) {
            httpRequest.setHeader(CYCLIC_HEADER, "true");
        }
        httpRequest.setHeader("Connection", this.isKeepAlive() ? "keep-alive" : "close");
        if (this.multiComputingCliRequest) {
            httpRequest.addHeader(new BasicHeader(MULTI_CLI_REQUEST, "true"));
        }
        if (StringUtils.isNotBlank(this.sessionId)) {
            httpRequest.setHeader(SESSION_HEADER, this.sessionId);
        }
        if (StringUtils.isNotBlank(this.mfaVerCode)) {
            httpRequest.setHeader(TFA_VERIFICATION_CODE, this.mfaVerCode);
        }
        if (StringUtils.isNotBlank(this.apiKey)) {
            httpRequest.setHeader(SESAM_API_KEY, this.apiKey);
        }
        if (StringUtils.isNotBlank(this.user) && this.certificateAuthHeader == null) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.user, this.password);
            try {
                httpRequest.addHeader(new BasicScheme().authenticate(creds, httpRequest, null));
            }
            catch (AuthenticationException e) {
                logger.error("call", LogGroup.ERROR, (LogMessage)new SimpleMessage("Failed to create HTTP authentication header: {0}"), e.getMessage());
            }
        } else if (this.certificateAuthHeader != null) {
            httpRequest.addHeader(this.certificateAuthHeader);
        }
        try {
            response = this.httpClient.execute(httpRequest);
        }
        catch (SSLException e) {
            throw new IOException(e.getMessage());
        }
        catch (IOException io) {
            httpRequest.setHeader("Connection", "close");
            response = this.httpClient.execute(httpRequest);
        }
        Header ctype = response.getFirstHeader("Content-type");
        try {
            JsonResult jres = this.checkForError(response, url);
            if (jres != null) {
                JsonResult jsonResult = jres;
                return jsonResult;
            }
            jres = new JsonResult();
            HttpEntity entity = response.getEntity();
            byte[] result = IOUtils.toByteArray(response.getEntity().getContent());
            EntityUtils.consume(entity);
            if (ctype != null) {
                if (ctype.getValue().contains(ContentType.APPLICATION_JSON.getMimeType())) {
                    String sres = new String(result, StandardCharsets.UTF_8);
                    jres.contentType = APPLICATION_JSON;
                    if ((debug || this.logLevel.is(SepLogLevel.TRACE)) && !this.cyclic) {
                        String time = this.getLocalTime();
                        System.out.println(time + " HTTP RESULT: " + url);
                        System.out.println(sres);
                        System.out.println("------");
                    }
                    lastHttpResult = sres;
                    jres.result = sres;
                } else {
                    jres.bres = result;
                    jres.contentType = BINARY;
                }
            }
            JsonResult jsonResult = jres;
            return jsonResult;
        }
        finally {
            httpRequest.reset();
            response.close();
        }
    }

    private String streamToString(InputStream stream) {
        assert (stream != null);
        try (Scanner s = new Scanner(stream, "UTF-8");){
            s.useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }

    public JsonResult checkForError(HttpResponse response, String url) throws IOException {
        assert (response != null);
        assert (url != null);
        JsonResult jres = null;
        if (response.getStatusLine().getStatusCode() == 404) {
            jres = new JsonResult();
            jres.restError = RestError.builder().withError(ConnectionException.ConnectionMessage.NO_SUCH_SERVICE.key()).withMessage("Unable to find service (404): " + url).withParameter(new String[]{url}).withType(ErrorType.CONNECTION).withUrl(url).build();
            lastHttpErrorResult = "Service Not Found (HTTP 404)";
        } else if (response.getStatusLine().getStatusCode() >= 400) {
            String result;
            jres = new JsonResult();
            lastHttpErrorResult = result = this.streamToString(response.getEntity().getContent());
            jres.restError = JsonUtil.read(result, RestError.class);
            if ((debug || this.logLevel.is(SepLogLevel.TRACE)) && !this.cyclic) {
                String time = this.getLocalTime();
                System.err.println(time + " HTTP ERROR RESULT: " + url);
                System.err.println("Error " + response.getStatusLine().getStatusCode());
                System.err.println(jres.restError.getError() + ": " + jres.restError.getMessage());
                System.err.println("------");
            }
            jres.restError.setUrl(url);
        }
        return jres;
    }

    public void setParameters(List<IQueryParameter> parameters) {
        this.parameters = parameters;
    }

    private List<IQueryParameter> getParameters() {
        return this.parameters;
    }

    public static String getLastHttpErrorResult() {
        if (lastHttpErrorResult == null) {
            return lastHttpResult;
        }
        return lastHttpErrorResult;
    }

    public static String getLastHttpResult() {
        if (lastHttpResult == null) {
            return lastHttpErrorResult;
        }
        return lastHttpResult;
    }

    public static void clearResults() {
        lastHttpErrorResult = null;
        lastHttpResult = null;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public void setCyclic(boolean cyclic) {
        this.cyclic = cyclic;
    }

    private String maskPassword(Object text) {
        String t;
        String string = t = text != null ? text.toString() : null;
        if (t != null && !t.trim().isEmpty()) {
            Matcher matcher = PW_PATTERN.matcher(t);
            while (matcher.find()) {
                StringBuilder sb = new StringBuilder(t.substring(0, matcher.start(2)));
                sb.append(StringUtils.repeat('*', 5));
                sb.append(t.substring(matcher.end(2)));
                t = sb.toString();
                matcher = PW_PATTERN.matcher(t);
            }
        }
        return t;
    }

    public Header enableCertificateBasedAuthentication(File certificateFile) {
        this.certificateAuthHeader = null;
        if (StringUtils.isNotBlank(this.user) && certificateFile != null && certificateFile.canRead()) {
            try {
                String pemString;
                String original = FileUtils.readFileToString(certificateFile, Charset.defaultCharset());
                if (StringUtils.isNotBlank(original) && StringUtils.isNotBlank(pemString = CertificateUtils.extractPemString(original))) {
                    StringBuilder auth = new StringBuilder();
                    auth.append(StringUtils.trim(this.user));
                    auth.append(":");
                    auth.append(pemString);
                    if (StringUtils.isNotBlank(this.password)) {
                        auth.append(":");
                        auth.append(this.password);
                    }
                    Base64 b64 = new Base64(0);
                    byte[] encoded = b64.encode(EncodingUtils.getBytes(auth.toString(), Consts.ASCII.name()));
                    CharArrayBuffer buffer = new CharArrayBuffer(32);
                    buffer.append("Authorization");
                    buffer.append(": X509 ");
                    buffer.append(encoded, 0, encoded.length);
                    this.certificateAuthHeader = new BufferedHeader(buffer);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.certificateAuthHeader;
    }

    private KeyStore buildKeyStore(File certificateFile) throws IOException {
        KeyStore keyStore;
        assert (certificateFile != null);
        try {
            String original = FileUtils.readFileToString(certificateFile, Charset.defaultCharset());
            if (StringUtils.isBlank(original)) {
                return null;
            }
            String pemString = CertificateUtils.extractPemString(original);
            byte[] decoded = Base64.decodeBase64(pemString);
            X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(decoded));
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            assert (keyStore != null);
            keyStore.load(null, null);
            keyStore.setCertificateEntry("1", certificate);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException(e);
        }
        return keyStore;
    }

    @Generated
    public void setRedirectServers(List<String> redirectServers) {
        this.redirectServers = redirectServers;
    }

    @Generated
    public void setMfaVerCode(String mfaVerCode) {
        this.mfaVerCode = mfaVerCode;
    }

    @Generated
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public void setCertificateAuthHeader(BufferedHeader certificateAuthHeader) {
        this.certificateAuthHeader = certificateAuthHeader;
    }

    @Generated
    public BufferedHeader getCertificateAuthHeader() {
        return this.certificateAuthHeader;
    }

    private static /* synthetic */ DefaultQueryParameter lambda$downloadV2$3(Map.Entry entry) {
        return new DefaultQueryParameter((String)entry.getKey(), (String)entry.getValue());
    }

    static {
        debug = Boolean.getBoolean("sep.sesam.rest.debug");
        APPLICATION_JSON = ContentType.create("application/json", Consts.UTF_8);
        BINARY = ContentType.create("binary/octed-stream");
        timeFormat = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
        PW_PATTERN = Pattern.compile("\"?(password|passwd|spasswd|os_password|os_passwd|sesam_passwd)\"?[:=\\s]+\"?([^\"*\\u2022\\s,]+)\"?");
    }
}

