/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest.exceptions;

import de.sep.sesam.common.logging.LogMessage;
import de.sep.sesam.common.logging.messages.SimpleMessage;
import de.sep.sesam.rest.utils.ErrorType;
import de.sep.sesam.rest.utils.HttpStatus;
import de.sep.sesam.rest.utils.RestError;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ServiceException
extends Exception {
    private static final long serialVersionUID = -1985911122420396900L;
    public Object[] data = null;
    private LogMessage message;
    private static final NumberFormat formatter = NumberFormat.getNumberInstance();

    public ServiceException() {
    }

    public ServiceException(LogMessage message, Object ... data) {
        super(message.key());
        this.init(message, data);
    }

    public ServiceException(Throwable cause, LogMessage message, Object ... data) {
        super(message.key(), cause);
        this.init(message, data);
    }

    protected void init(LogMessage message, Object ... data) {
        this.message = message;
        if (data != null && data.length > 0) {
            Object[] dataCopy = new Object[data.length];
            for (int i = 0; i < data.length; ++i) {
                Object o = data[i];
                dataCopy[i] = o instanceof Number ? formatter.format(o) : o;
            }
            this.data = dataCopy;
        } else {
            this.data = data;
        }
    }

    public abstract String getHeader();

    public String getLongMessage() {
        String msg = "";
        try {
            msg = this.data != null ? MessageFormat.format(this.message.message(), this.data) : this.message.message();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return StringUtils.trim(msg);
    }

    public void setLongMessage(String key, String message) {
        assert (StringUtils.isNotBlank(key));
        assert (StringUtils.isNotBlank(message));
        this.message = new SimpleMessage(key, message);
    }

    @Override
    public String getLocalizedMessage() {
        return (String)(StringUtils.isNotBlank(this.getKey()) ? this.getKey() + ": " : "") + this.getLongMessage();
    }

    public String getKey() {
        return this.message.key();
    }

    public abstract HttpStatus getStatusCode();

    @Override
    public String toString() {
        return this.getLongMessage();
    }

    public LogMessage getLogMessage() {
        return this.message;
    }

    @Override
    public String getMessage() {
        return this.getLongMessage();
    }

    public Object[] getParameter() {
        return this.data;
    }

    abstract ErrorType getType();

    public RestError toError() {
        String[] parameter = null;
        if (ArrayUtils.isNotEmpty(this.data)) {
            parameter = new String[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                parameter[i] = this.data[i] == null ? "null" : StringUtils.trim(this.data[i].toString());
            }
        }
        RestError error = RestError.builder().withError(this.getKey()).withMessage(this.getLongMessage()).withParameter(parameter).withType(this.getType()).build();
        return error;
    }

    static {
        formatter.setGroupingUsed(false);
    }
}

