/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest.exceptions;

import de.sep.sesam.common.logging.LogMessage;
import de.sep.sesam.rest.exceptions.ServiceException;
import de.sep.sesam.rest.utils.ErrorType;
import de.sep.sesam.rest.utils.HttpStatus;
import de.sep.sesam.rest.utils.RestError;

public class OperationNotPossibleException
extends ServiceException {
    private static final long serialVersionUID = -4251857827451285232L;

    public OperationNotPossibleException(ONPMessage message, Object ... data) {
        super(message, data);
    }

    public OperationNotPossibleException(Throwable cause, LogMessage message, Object ... data) {
        super(cause, message, data);
    }

    @Override
    public String getHeader() {
        return "Operation Not Possible";
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.SERVER_ERROR_INTERNAL;
    }

    @Override
    ErrorType getType() {
        return ErrorType.OPERATION_NOT_POSSIBLE;
    }

    public static OperationNotPossibleException fromError(RestError error) {
        ONPMessage msg = null;
        for (ONPMessage cur : ONPMessage.values()) {
            if (!error.getError().equals(cur.key)) continue;
            msg = cur;
            break;
        }
        return msg != null ? new OperationNotPossibleException(msg, (Object[])error.getParameter()) : null;
    }

    public static enum ONPMessage implements LogMessage
    {
        DATABASE_BUSY("database.busy", "Database is busy. Please retry the latest action or contact the administrator if the problem persists."),
        DATABASE_ERROR("database.error", "Database Error: {0}"),
        DATASTORE_PATH_EXISTS("datastore.path.exists", "Datastore cannot be created. The datastore path {0} already exists."),
        DELETE_LAST_SESAM_BACKUP("delete.last.sesam.backup", "{0}"),
        DUPLICATE_ENTRY("duplicate.entry", "Duplicate entry. Unable to save. ({0} - {1})"),
        DUPLICATE_ENTRY_CASE_INSENSITIVE("Duplicate.entry", "Duplicate entry (Case insensitive).  Unable to save. ({0} already exists with name {1})"),
        DUPLICATE_ENTRY_BY_NAME("duplicate.entry.name", "The {0} name ''{1}'' is not unique. Please choose a unique name."),
        DUPLICATE_NAME("duplicate.name", "The {0} name ''{1}'' is not unique. Please choose a unique event name or leave empty to auto generate one."),
        ERROR_WHILE_SAVING("error.while.saving", "Fatal error while saving: {0}"),
        INVALID_RESULTS("invalid.results", "Invalid results found for: {0}"),
        EXTERNAL_PROCESS_FAILED("external.process.failed", "External process failed: {0}"),
        EXTERNAL_CALL_FAILED("external.call.failed", "External process failed with code: {0}. Message: {1}"),
        INTERNAL_ERROR("internal.error", "Unknown internal error occurred. Please notify the administrator:\n\nDetails:\n{0}"),
        INVALID_API("invalid.api", "API {0} not found."),
        INVALID_ACTION("invalid.action", "Action invalid or not found {0}: {1}"),
        INVALID_PASSWORD("invalid.password", "{0}"),
        INVALID_STATE("invalid.state", "Invalid state for {0}: {1}"),
        INVALID_REQUEST("invalid.request", "Unable to process {0}: {1}"),
        INVALID_REQUEST_WITH_CAUSE("invalid.requestWithCause", "Unable to process {0}: {1}. Cause: {2}"),
        LICENSE_INVALID("license.invalid", "Available licenses for backup type ''{0}'' exceeded ({1} of {2})."),
        LICENSE_MISSING("license.missing", "No license available for backup type ''{0}''."),
        NOT_READABLE("not.readable", "Unable to read {0} ({1})"),
        NOT_WRITEABLE("not.writeable", "Unable to write {0} ({1})"),
        NOT_EXECUTABLE("not.executable", "Unable to execute {0} ({1})"),
        MAIL_SEND_FAILED("mail.send.failed", "Failed to send the e-mail to all or some recipients. {0}"),
        STARTUP("startup", "The startup is still in progress. Please retry in a few moments."),
        FORBIDDEN("forbidden", "Bad request. Route {0} does not exist."),
        INSUFFICIENT_PERMISSIONS("insufficient.permission", "Permissions insufficient to {0}"),
        EXCEPTION("exception", "Fatal error: {0}"),
        PASS_THROUGH("pass.through", "{0}"),
        SOURCE_POOL_CORRELATES_WITH_TARGET_POOL("source.pool.correlates.with.target.pool", "Target pool and source pool correlate with each other."),
        TOO_MANY_RESULTS_FOUND_FOR_NAME("too.many.results.found.for.name", "There are more than one saveset for the saveset id {0}. Try to use find."),
        MISSING_PARAMETER("missing.parameter", "Missing parameter: {0}"),
        VMBUFFER_BUSY("vm buffer", "Buffer is currently refreshing. ({0})");

        private String key;
        private String defaultMessage;

        private ONPMessage(String key, String defaultMessage) {
            this.key = key;
            this.defaultMessage = defaultMessage;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String message() {
            return this.defaultMessage;
        }
    }
}

