/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest.exceptions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.logging.messages.ErrorMessages;
import de.sep.sesam.rest.exceptions.ServiceException;
import de.sep.sesam.rest.utils.ErrorType;
import de.sep.sesam.rest.utils.HttpStatus;
import de.sep.sesam.rest.utils.RestError;

public class ObjectNotFoundException
extends ServiceException {
    @JsonIgnore
    private static final long serialVersionUID = -350241861068854006L;

    public ObjectNotFoundException(String object, Object id) {
        if (id == null) {
            this.init(ErrorMessages.OBJECT_NOT_FOUND, object);
        } else {
            this.init(ErrorMessages.OBJECT_NOT_FOUND_ID, object, id);
        }
    }

    @Override
    public String getHeader() {
        return "Object Not Found";
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.SERVER_ERROR_INTERNAL;
    }

    @Override
    ErrorType getType() {
        return ErrorType.OBJECT_NOT_FOUND;
    }

    public static ObjectNotFoundException fromError(RestError error) {
        if (error.getParameter().length == 1) {
            return new ObjectNotFoundException(error.getParameter()[0], (Object)"");
        }
        return new ObjectNotFoundException(error.getParameter()[0], (Object)error.getParameter()[1]);
    }
}

