/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest.exceptions;

import de.sep.sesam.common.logging.LogMessage;
import de.sep.sesam.model.core.interfaces.IEntity;
import de.sep.sesam.rest.exceptions.ServiceException;
import de.sep.sesam.rest.utils.ErrorType;
import de.sep.sesam.rest.utils.HttpStatus;
import de.sep.sesam.rest.utils.RestError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ObjectInUseException
extends ServiceException {
    private static final long serialVersionUID = 3113734855600572527L;
    private Class<?> objectType;
    private Object id;
    private List<IEntity<?>> referenceObjects = new ArrayList();

    public ObjectInUseException(Class<?> objectType, Object id, Collection<? extends IEntity<?>> param) {
        this(objectType, id, false, param);
    }

    public ObjectInUseException(Class<?> objectType, Object id, final boolean isDataMoverReference, Collection<? extends IEntity<?>> param) {
        super(new LogMessage(){

            @Override
            public String message() {
                return "Unable to comply. The given entity is still in use" + (isDataMoverReference ? " as data mover" : "") + ": {0} ";
            }

            @Override
            public String key() {
                return "object.in.use";
            }
        }, objectType != null ? objectType.getName() : "", id);
        this.objectType = objectType;
        this.id = id;
        StringBuilder sb = new StringBuilder();
        if (param != null) {
            for (IEntity<?> entry : param) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(entry.getClass().getSimpleName());
                sb.append('(');
                sb.append(entry.getPK());
                sb.append(')');
            }
            Object[] newData = new Object[this.data.length + 1];
            for (int i = 0; i < this.data.length; ++i) {
                newData[i + 1] = this.data[i];
            }
            newData[0] = sb.toString();
            this.data = newData;
            this.referenceObjects.addAll(param);
        }
    }

    public ObjectInUseException(String objectType, String id) {
        super(new LogMessage(){

            @Override
            public String message() {
                return "Unable to comply. The given entity is still in use.";
            }

            @Override
            public String key() {
                return "object.in.use";
            }
        }, objectType, id);
        this.id = id;
    }

    @Override
    public String getHeader() {
        return "Operation Not Possible";
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.SERVER_ERROR_INTERNAL;
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public Object getId() {
        return this.id;
    }

    public Collection<? extends IEntity<?>> getReferenceObjects() {
        return this.referenceObjects;
    }

    public boolean hasReferences() {
        return this.referenceObjects.size() > 0;
    }

    @Override
    ErrorType getType() {
        return ErrorType.OBJECT_IN_USE;
    }

    @Override
    public RestError toError() {
        return super.toError();
    }

    public static ObjectInUseException fromError(RestError error) {
        assert (error != null);
        String objectTypeName = null;
        String id = null;
        if (error.getParameter() != null) {
            objectTypeName = error.getParameter().length >= 2 ? error.getParameter()[error.getParameter().length - 2] : null;
            id = error.getParameter().length >= 1 ? error.getParameter()[error.getParameter().length - 1] : null;
        }
        Class<?> objectType = null;
        try {
            objectType = Class.forName(objectTypeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ObjectInUseException exc = new ObjectInUseException(objectType, id, false, null);
        assert (exc != null);
        exc.setLongMessage(error.getError(), error.getMessage());
        return exc;
    }
}

