/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest.exceptions;

import de.sep.sesam.common.logging.LogMessage;
import de.sep.sesam.rest.exceptions.ServiceException;
import de.sep.sesam.rest.utils.ErrorType;
import de.sep.sesam.rest.utils.HttpStatus;
import de.sep.sesam.rest.utils.RestError;

public class NotEditableException
extends ServiceException {
    private static final long serialVersionUID = 1L;

    public NotEditableException(NEEMessage s, Object ... param) {
        super(s, param);
    }

    @Override
    public String getHeader() {
        return "Not Editable";
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.CLIENT_ERROR_METHOD_NOT_ALLOWED;
    }

    @Override
    ErrorType getType() {
        return ErrorType.NOT_EDITABLE;
    }

    public static NotEditableException fromError(RestError error) {
        NEEMessage msg = null;
        for (NEEMessage cur : NEEMessage.values()) {
            if (!error.getError().equals(cur.key)) continue;
            msg = cur;
            break;
        }
        return msg != null ? new NotEditableException(msg, (Object[])error.getParameter()) : null;
    }

    public static enum NEEMessage implements LogMessage
    {
        TABLE_NOT_EDITABLE("table.is.not.editable", "Unable to insert or update table {0}. It is a read only table."),
        FIELD_NOT_EDITABLE("field.is.not.editable", "Unable to insert or update value {0} in column {1}. It is a read only column.");

        private String key;
        private String defaultMessage;

        private NEEMessage(String key, String defaultMessage) {
            this.key = key;
            this.defaultMessage = defaultMessage;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String message() {
            return this.defaultMessage;
        }
    }
}

