/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest.exceptions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.logging.LogMessage;
import de.sep.sesam.common.logging.messages.ErrorMessages;
import de.sep.sesam.rest.exceptions.ServiceException;
import de.sep.sesam.rest.utils.ErrorType;
import de.sep.sesam.rest.utils.HttpStatus;
import de.sep.sesam.rest.utils.RestError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.sf.oval.ConstraintViolation;
import org.apache.commons.lang3.StringUtils;

public class InvalidValueException
extends ServiceException {
    @JsonIgnore
    private static final long serialVersionUID = -4500470441516624067L;

    public InvalidValueException(String fieldName) {
        super(ErrorMessages.INVALID_VALUE, StringUtils.trim(StringUtils.removeStart(fieldName, "Invalid Value:")));
    }

    public static ViolationObject get(ConstraintViolation cv) {
        ViolationObject vo = new ViolationObject();
        vo.message = ErrorMessages.INVALID_VALUE;
        vo.field = cv.getContextPathAsString();
        if (cv.getCheckName().endsWith("NotNullCheck")) {
            vo.message = ErrorMessages.MISSING_FIELD;
        } else if (cv.getCheckName().endsWith("LengthCheck")) {
            vo.message = ErrorMessages.INVALID_FIELD_LENGTH;
            vo.value = cv.getInvalidValue().getClass().getName() + ": " + cv.getInvalidValue().toString();
        } else {
            System.out.println("Unhandled constraint violation: " + cv.getCheckName());
        }
        return vo;
    }

    public InvalidValueException(Collection<ConstraintViolation> violations) {
        super(ErrorMessages.INVALID_VALUES, new Object[0]);
        if (violations.size() == 1) {
            ViolationObject vo = InvalidValueException.get(violations.iterator().next());
            this.init(vo.message, vo.field, vo.value);
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<ViolationObject> params = new ArrayList<ViolationObject>();
        for (ConstraintViolation cv : violations) {
            ViolationObject vo = InvalidValueException.get(cv);
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(vo.field);
            params.add(vo);
        }
        Object[] paramArr = new Object[params.size() + 1];
        paramArr[0] = sb.toString();
        for (int i = 0; i < params.size(); ++i) {
            paramArr[i + 1] = params.get(i);
        }
        this.init(ErrorMessages.INVALID_VALUES, sb.toString(), params.toArray());
    }

    public InvalidValueException(ConstraintViolation ... constraintViolations) {
        this(Arrays.asList(constraintViolations));
    }

    @Override
    public String getHeader() {
        return "Invalid Value";
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.SERVER_ERROR_INTERNAL;
    }

    @Override
    public String getMessage() {
        return this.getLongMessage();
    }

    @Override
    ErrorType getType() {
        return ErrorType.INVALID_VALUE;
    }

    public static InvalidValueException fromError(RestError error) {
        return new InvalidValueException(error.getMessage());
    }

    private static class ViolationObject {
        String field;
        LogMessage message;
        Object value;

        private ViolationObject() {
        }
    }
}

