/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest.exceptions;

import de.sep.sesam.common.logging.LogMessage;
import de.sep.sesam.rest.exceptions.ServiceException;
import de.sep.sesam.rest.utils.ErrorType;
import de.sep.sesam.rest.utils.HttpStatus;
import de.sep.sesam.rest.utils.RestError;

public class IllegalParameterException
extends ServiceException {
    private static final long serialVersionUID = -6199296110946932037L;

    public IllegalParameterException(IPEMessage s, Object ... param) {
        super(s, param);
    }

    @Override
    public String getHeader() {
        return "Illegal Parameter";
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.CLIENT_ERROR_BAD_REQUEST;
    }

    @Override
    ErrorType getType() {
        return ErrorType.ILLEGAL_PARAMETER;
    }

    public static IllegalParameterException fromError(RestError error) {
        IPEMessage msg = null;
        for (IPEMessage cur : IPEMessage.values()) {
            if (!error.getError().equals(cur.key)) continue;
            msg = cur;
            break;
        }
        return msg != null ? new IllegalParameterException(msg, (Object[])error.getParameter()) : null;
    }

    public static enum IPEMessage implements LogMessage
    {
        PARAMETER_MISSING("parameter.is.missing", "Parameter {0} is missing."),
        OBJECT_IS_NULL("object.is.null", "Parameter {0} is null."),
        CONSTRAINT_DUPLICATE("duplicate.field", "Fields {0} must be unique."),
        CONSTRAINT_DUPLICATE_PK("duplicate.pk", "The primary key (''{0}'') is not unique."),
        INVALID_VALUE("invalid.value", "Parameter {0} is invalid."),
        INVALID_CONTENT("invalid.content", "Parameter {0} is invalid: {1}"),
        INVALID_NUMBER_OF_PARAMETERS("invalid.number", "Invalid number of parameters. Expected ({0}) != Provided ({1})."),
        UNABLE_TO_PARSE("unable.parse", "Unable to parse input on {0}. ({1}):\n{2}"),
        FUNCTION_PARAMTER("function.parameter.missing", "{0}#{1} requires {2} parameter."),
        QUERY_PARAMETER_MISSING("query_parameter.is.missing", "A call to ''{0}'' must be parameterized via URL query parameter.");

        private String key;
        private String defaultMessage;

        private IPEMessage(String key, String defaultMessage) {
            this.key = key;
            this.defaultMessage = defaultMessage;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String message() {
            return this.defaultMessage;
        }
    }
}

