/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest.exceptions;

import de.sep.sesam.common.date.DateUtils;
import de.sep.sesam.common.logging.LogMessage;
import de.sep.sesam.rest.exceptions.ServiceException;
import de.sep.sesam.rest.utils.ErrorType;
import de.sep.sesam.rest.utils.HttpStatus;
import de.sep.sesam.rest.utils.RestError;
import java.util.Date;

public class ConnectionException
extends ServiceException {
    private static final long serialVersionUID = 7175674715058118616L;

    public ConnectionException(ConnectionMessage s, Object ... param) {
        super(s, param);
    }

    @Override
    public String getHeader() {
        return "Unable To Connect";
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.SERVER_ERROR_SERVICE_UNAVAILABLE;
    }

    public static ConnectionException fromError(RestError error) {
        assert (error != null);
        ConnectionMessage msg = null;
        for (ConnectionMessage cur : ConnectionMessage.values()) {
            if (!error.getError().equals(cur.key)) continue;
            msg = cur;
            break;
        }
        if (msg == null) {
            return new ConnectionException(ConnectionMessage.INVALID_REQUEST, error.getMessage());
        }
        return new ConnectionException(msg, (Object[])error.getParameter());
    }

    @Override
    ErrorType getType() {
        return ErrorType.CONNECTION;
    }

    public static enum ConnectionMessage implements LogMessage
    {
        UNABLE_TO_CONNECT("unable.to.connect", "Unable to connect to {0}:{1} {2}(" + ConnectionMessage.date() + ")"),
        UNABLE_TO_CONNECT_DB("unable.to.connect.db", "Unable to connect to the database backend on {0}:{1} (" + ConnectionMessage.date() + ")"),
        CONNECT_NOT_POSSIBLE("connect.not.possible", "Connect not possible to {0} (" + ConnectionMessage.date() + ")"),
        DATA_EXCEPTION("data.exception", "Problem with request to {0}:{1}: {2}"),
        TIMEOUT("connection.timeout", "Timeout while retrieving data."),
        UNKNOWN_HOST("unknown.host", "Unknown host ''{0}''. {1}"),
        NO_SUCH_METHOD("no.such.method", "Method {0} not found. Probably wrong version."),
        INVALID_DATA("invalid.data", "Invalid data from {0}. Caused by: {1}"),
        INVALID_REQUEST("invalid.request", "Invalid Request {0}"),
        INVALID_LOGIN("invalid.login", "Invalid Login to {0}"),
        NO_SUCH_SERVICE("no.such.service", "Unable to find requested service {0}");

        private final String key;
        private final String defaultMessage;

        private ConnectionMessage(String key, String defaultMessage) {
            this.key = key;
            this.defaultMessage = defaultMessage;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String message() {
            return this.defaultMessage;
        }

        public static String date() {
            return DateUtils.dateToDateOnlyStr(new Date());
        }
    }
}

