/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest.exceptions;

import de.sep.sesam.common.logging.LogMessage;
import de.sep.sesam.rest.exceptions.ServiceException;
import de.sep.sesam.rest.utils.ErrorType;
import de.sep.sesam.rest.utils.HttpStatus;
import de.sep.sesam.rest.utils.RestError;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class CliCommonErrorException
extends ServiceException
implements Serializable {
    private static final long serialVersionUID = -4066866475133906759L;

    public CliCommonErrorException(LogMessage message, Object ... data) {
        super(message, data);
    }

    @Override
    public String getHeader() {
        return "CLI ERROR";
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.SERVER_ERROR_INTERNAL;
    }

    @Override
    ErrorType getType() {
        return ErrorType.CLI_COMMON_ERROR;
    }

    @Override
    public String getLocalizedMessage() {
        return StringUtils.substringAfter(super.getLocalizedMessage(), ": ");
    }

    public static CliCommonErrorException fromError(RestError error) {
        CCEMessage msg = null;
        for (CCEMessage cur : CCEMessage.values()) {
            if (!error.getError().equals(cur.key)) continue;
            msg = cur;
            break;
        }
        return msg != null ? new CliCommonErrorException(msg, error.getParameter()) : null;
    }

    public static enum CCEMessage implements LogMessage
    {
        OBJECT_NOT_FOUND("object.not.found", "{0}"),
        INVALID_VALUE("invalid.value", "{0}"),
        GENERAL_ERROR("general.error", "{0}");

        private final String key;
        private final String defaultMessage;

        private CCEMessage(String key, String defaultMessage) {
            this.key = key;
            this.defaultMessage = defaultMessage;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String message() {
            return this.defaultMessage;
        }
    }
}

