/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest.exceptions;

import de.sep.sesam.common.logging.LogMessage;
import de.sep.sesam.rest.exceptions.ServiceException;
import de.sep.sesam.rest.utils.ErrorType;
import de.sep.sesam.rest.utils.HttpStatus;
import de.sep.sesam.rest.utils.RestError;

public class AuthenticationException
extends ServiceException {
    private static final long serialVersionUID = -158115231621575624L;

    public AuthenticationException(AuthMessage s, Object ... param) {
        super(s, param);
    }

    @Override
    public String getHeader() {
        return "Authentication Error";
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.CLIENT_ERROR_UNAUTHORIZED;
    }

    @Override
    ErrorType getType() {
        return ErrorType.AUTHENTICATION;
    }

    public static AuthenticationException fromError(RestError error) {
        AuthMessage msg = null;
        for (AuthMessage cur : AuthMessage.values()) {
            if (!error.getError().equals(cur.key)) continue;
            msg = cur;
            break;
        }
        return msg != null ? new AuthenticationException(msg, (Object[])error.getParameter()) : null;
    }

    public static enum AuthMessage implements LogMessage
    {
        NOT_LOGGED_IN("not.loggedin", "User is not logged in."),
        NO_SESSION("no.session", "No session for {0}."),
        CREDENTIALS_INVALID("credentials.invalid", "Login failed for user ''{0}''. Invalid user/password combination."),
        CERTIFICATE_INVALID("certificate.invalid", "Certificate provided to authenticate user ''{0}'' is invalid."),
        API_KEY_INVALID("key.invalid", "Sesam API key provided to authenticate user ''{0}'' is invalid."),
        CERTIFICATE_EXPIRED("certificate.expired", "Login failed for user ''{0}''. The provided user authentication certificate is expired.\n\nPlease contact your administrator to solve the issue."),
        CERTIFICATE_INACTIVE("certificate.inactive", "Login failed for user ''{0}''. The provided user authentication certificate is not active yet.\n\nPlease contact your administrator to solve the issue."),
        CERTIFICATE_UNASSOCIATED("certificate.unassociated", "Login failed for user ''{0}''. The provided user authentication certificate is not associated with the user account.\n\nPlease contact your administrator to solve the issue."),
        ACCOUNT_INVALID("account.invalid", "Login failed for user ''{0}''. User account is expired or locked.\n\nPlease contact your administrator to solve the issue."),
        ADMIN_ACCOUNT_INVALID("adminaccount.invalid", "Login failed for user ''{0}''. User account is expired or locked.\n\nWait for 10 minutes."),
        PASSWORD_EXPIRED("password.expired", "Login failed for user ''{0}''. The password is expired.\n\nPlease contact your administrator to solve the issue."),
        PASSWORD_INVALID("password.invalid", "Login failed for user ''{0}''. The password is invalid.\n\nPlease contact your administrator to solve the issue."),
        USER_DISABLED("user.disabled", "Login failed for user ''{0}''. User account is disabled.\n\nPlease contact your administrator to solve the issue."),
        USER_MISSING("user.missing", "Login failed for user ''{0}''. User account auto create or update failed.\n\nPlease contact your administrator to solve the issue."),
        NO_MAPPING("no.mapping", "Login failed for user ''{0}''. None of the user groups can be mapped to a Sesam group."),
        NO_AUTHORITIES("no.authorities", "Login failed for user ''{0}''. User is not assigned to any group and therefore cannot be mapped to any Sesam group."),
        DB_ERROR("server.error", "Login failed for user ''{0}''. No '{1}' has been found. Please contact your administrator to solve the issue"),
        TFA_CODE_INVALID("code.invalid", "Login failed for user ''{0}''. Verification code is invalid. Please try to login again."),
        TFA_VALIDATION_NEEDED("validation.needed", "Login failed for user ''{0}''. User has multi-factor authentication enabled."),
        TFA_CODE_ERROR("code.error", "Login failed for user ''{0}''. Verification code generation is failed. Please contact your administrator to solve the issue."),
        TFA_NO_ACC("mail.error", "Login failed for user ''{0}''. Error while sending mail with verification code. No account with name 'sesam' exist."),
        TFA_MAIL_ERROR("mail.error", "Login failed for user ''{0}''. Error while sending mail."),
        COMMUNICATION_FAILED("comm.failed", "Communication failure: {0}"),
        SERVER_ERROR("server.error", "Login failed for user ''{0}''. An internal error occurred. This might be caused by the server not sending required attributes.");

        private String key;
        private String defaultMessage;

        private AuthMessage(String key, String defaultMessage) {
            this.key = key;
            this.defaultMessage = defaultMessage;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String message() {
            return this.defaultMessage;
        }
    }
}

