/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.rest;

import de.sep.sesam.rest.json.JsonHttpRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;

public class RestSession {
    private String id;
    private String user;
    private String password;
    private String certificateEncoded;
    private final String server;
    private int port = 11401;
    private final CloseableHttpClient httpClient;

    public RestSession(String server, int port) {
        assert (server != null);
        this.server = server;
        this.port = port;
        if (this.port <= 0) {
            this.port = 11401;
        }
        this.httpClient = JsonHttpRequest.buildHttpClient(false, 0);
    }

    public final boolean isLoggedIn() {
        return StringUtils.isNotBlank(this.id) && StringUtils.isNotBlank(this.user);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getCertificateEncoded() {
        return this.certificateEncoded;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setCertificateEncoded(String certificateEncoded) {
        this.certificateEncoded = certificateEncoded;
    }
}

