/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.vms.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractSerializableObject;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class VMGroupRetvalDto
extends AbstractSerializableObject {
    @JsonIgnore
    private static final long serialVersionUID = 7993589543802983169L;
    private String grpName;
    private int verbosity;
    private List<String> trace;
    private int taskInGrp;
    private int added;
    private int removed;
    private int clientsAdded;
    private int clientsRemoved;

    public VMGroupRetvalDto(int taskInGrp, String grpName, int added, int removed) {
        this.taskInGrp = taskInGrp;
        this.grpName = grpName;
        this.added = added;
        this.removed = removed;
    }

    public void trace(String message) {
        if (this.verbosity == 0 || StringUtils.isBlank(message)) {
            return;
        }
        if (this.trace == null) {
            this.trace = new ArrayList<String>();
        }
        assert (this.trace != null);
        this.trace.add(message);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.verbosity > 0 && CollectionUtils.isNotEmpty(this.trace)) {
            this.trace.forEach(t -> s.append(String.format("TRACE: %s\n", t)));
        }
        s.append("STATUS=SUCCESS MSG=\"");
        if (StringUtils.isNotBlank(this.grpName)) {
            s.append(String.format("%s tasks in group '%s', ", this.taskInGrp, this.grpName));
        }
        s.append(String.format("%s added, %s removed", this.added, this.removed));
        if (this.clientsAdded > 0 || this.clientsRemoved > 0) {
            s.append(String.format(", %s clients added, %s clients removed", this.clientsAdded, this.clientsRemoved));
        }
        s.append("\"");
        return s.toString();
    }

    @Generated
    public String getGrpName() {
        return this.grpName;
    }

    @Generated
    public int getVerbosity() {
        return this.verbosity;
    }

    @Generated
    public List<String> getTrace() {
        return this.trace;
    }

    @Generated
    public int getTaskInGrp() {
        return this.taskInGrp;
    }

    @Generated
    public int getAdded() {
        return this.added;
    }

    @Generated
    public int getRemoved() {
        return this.removed;
    }

    @Generated
    public int getClientsAdded() {
        return this.clientsAdded;
    }

    @Generated
    public int getClientsRemoved() {
        return this.clientsRemoved;
    }

    @Generated
    public void setGrpName(String grpName) {
        this.grpName = grpName;
    }

    @Generated
    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    @Generated
    public void setTrace(List<String> trace) {
        this.trace = trace;
    }

    @Generated
    public void setTaskInGrp(int taskInGrp) {
        this.taskInGrp = taskInGrp;
    }

    @Generated
    public void setAdded(int added) {
        this.added = added;
    }

    @Generated
    public void setRemoved(int removed) {
        this.removed = removed;
    }

    @Generated
    public void setClientsAdded(int clientsAdded) {
        this.clientsAdded = clientsAdded;
    }

    @Generated
    public void setClientsRemoved(int clientsRemoved) {
        this.clientsRemoved = clientsRemoved;
    }

    @Generated
    public VMGroupRetvalDto() {
    }
}

