/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.vms.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.util.Joiner;
import de.sep.sesam.model.Clients;
import de.sep.sesam.model.Tasks;
import de.sep.sesam.model.browser.dto.FileDto;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.browser.LisInfoKeyValuePair;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.types.BackupType;
import de.sep.sesam.model.core.types.PowerStateType;
import de.sep.sesam.model.vms.dto.VMAttributesDto;
import de.sep.sesam.model.vms.dto.VMDKDto;
import de.sep.sesam.model.vms.dto.VMSnapshotDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

@Schema(description="VM DTO")
public final class VMDto
extends AbstractSerializableObject
implements IDisplayLabelProvider {
    private static final long serialVersionUID = 2028573451086090598L;
    @Schema(description="VM name", example="vm-001")
    public String name;
    @Schema(description="VM description", example="VM description")
    public String description;
    @Schema(description="vSphere server of VM", example="vcenter.domain.com")
    private String serverName;
    @Schema(description="clients.vm_name and show clients.name", example="client1")
    private String vmClient;
    @Schema(description="vSphere server of VM", example="true")
    private boolean isVCenter;
    @Schema(description="VM browser path", example="/vm/vm-001")
    private String path;
    @Schema(description="dataCenter of VM", example="datacenter-001")
    private String dataCenter;
    @Schema(description="VM name", example="vm-001")
    private List<VMDKDto> vmdkData;
    @Schema(description="VM moRef", example="vm-27")
    private String moRef;
    @Schema(description="VM powerstate", example="off", defaultValue="NONE")
    private PowerStateType powerState = PowerStateType.NONE;
    @Schema(description="VM ip address", example="192.168.1.1")
    private String ipAddress;
    @Schema(description="VM host name depends on IP", example="vm-001.domain.com")
    private String vmHost;
    @Schema(description="VM network mac address", example="00:50:56:96:00:01")
    private String macAddress;
    @Schema(description="VM network mac address", example="00:50:56:96:00:01")
    private List<String> networks;
    @Schema(description="ESX server of VM", example="esx-001.domain.com")
    private String hostSystem;
    @Schema(description="cluster, which contain the VM", example="cluster-001")
    private String cluster;
    @Schema(description="Flag to indicated if the VM is located on a cluster (Hyper-V)", example="true")
    private Boolean clustered;
    @Schema(description="CBT state of VM", example="true")
    private Boolean changeBlockTracking;
    @Schema(description="version of VM", example="5.5.0")
    private String version;
    @Schema(description="OS config of VM (linux,windows,...)", example="linux")
    private String guestFullName;
    @Schema(description="VM internal uuid, which is distinct", example="1234567890")
    private String uuid;
    @Schema(description="size of VM", example="1024")
    private Long size;
    @Schema(description="", example="true", defaultValue="true")
    private boolean resetCBTModeSoft = true;
    @Schema(description="The backup task.")
    private Tasks task;
    @Schema(description="The backup task names list.")
    private List<String> tasks;
    @Schema(description="parent of VM", example="vm-001")
    private String folder;
    @Schema(description="custom flag, which describe, if VM exists", example="true", defaultValue="true")
    private Boolean exist = Boolean.TRUE;
    private String vApp;
    private String resourcepool;
    private List<String> annotations;
    private List<VMAttributesDto> attributes;
    private List<VMSnapshotDto> snapshots;
    private List<LisInfoKeyValuePair> additionalInfo;
    private List<String> tags;
    @Schema(description="The task group name.")
    private String taskGroupRef;
    private String hostVersion;
    private List<String> dataStores;
    private Boolean guestToolsRunning;
    private BackupType backupType;
    private String type;
    @Schema(description="The client name template of the client object, generated for a given task.", example="{{client}}")
    private String taskGenClientName;
    @Schema(description="The location name of the client object, generated for a given task.", example="{{location}}")
    private String taskGenLocationName;
    @Schema(description="The operating system name of the client object, generated for a given task.", example="{{os}}")
    private String taskGenOperSystemName;

    public VMDto(String vm, String dataCenter) {
        this.name = vm;
        this.dataCenter = dataCenter;
    }

    public VMDto(Clients server, String vm, String dataCenter) {
        this(vm, dataCenter);
        this.serverName = server.getName();
    }

    public String getClient() {
        return this.serverName;
    }

    @JsonIgnore
    public String getSesamPath() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank(this.serverName)) {
            sb.append("/");
            sb.append(this.serverName);
            sb.append("/");
        }
        if (this.backupType != null) {
            sb.append(this.backupType.getTypeName());
        } else {
            sb.append("VMware vSphere");
        }
        sb.append(":");
        if (StringUtils.isNotBlank(this.dataCenter)) {
            sb.append("/");
            sb.append(this.dataCenter);
        }
        if (StringUtils.isNotBlank(this.name)) {
            sb.append("/");
            sb.append(this.name);
        }
        return sb.toString();
    }

    @JsonIgnore
    public void setSesamPath(String path) {
        assert (StringUtils.isNotBlank(path));
        String vmPatternRegex = "/([^\"]*)/.*/(.*)/([^\"]*)";
        Pattern pattern = Pattern.compile(vmPatternRegex);
        Matcher matcher = pattern.matcher(path);
        if (matcher.find()) {
            this.setServerName(matcher.group(1));
            this.setDataCenter(matcher.group(2).equals("null") ? null : matcher.group(2));
            this.setName(matcher.group(3));
        }
    }

    @JsonIgnore
    public List<LisInfoKeyValuePair> getAdditionalInfo() {
        if (this.additionalInfo == null) {
            List values;
            ArrayList<LisInfoKeyValuePair> pairs = new ArrayList<LisInfoKeyValuePair>();
            if (StringUtils.isNotBlank(this.serverName)) {
                pairs.add(this.makePair("vcenter", this.serverName));
            }
            if (StringUtils.isNotBlank(this.name)) {
                pairs.add(this.makePair("vmname", this.name));
            }
            if (StringUtils.isNotBlank(this.moRef)) {
                pairs.add(this.makePair("moref", this.moRef));
            }
            if (StringUtils.isNotBlank(this.dataCenter)) {
                pairs.add(this.makePair("datacenter", this.dataCenter));
            }
            if (StringUtils.isNotBlank(this.hostSystem)) {
                pairs.add(this.makePair("hostSystem", this.hostSystem));
            }
            if (StringUtils.isNotBlank(this.hostVersion)) {
                pairs.add(this.makePair("hostversion", this.hostVersion));
            }
            if (this.powerState != null && !PowerStateType.NONE.equals((Object)this.powerState)) {
                pairs.add(this.makePair("powerState", this.powerState.toString()));
            }
            if (StringUtils.isNotBlank(this.macAddress)) {
                pairs.add(this.makePair("mac_addresses", this.macAddress));
            }
            if (this.guestToolsRunning != null) {
                pairs.add(this.makePair("guest_tools_running", StringUtils.lowerCase(this.guestToolsRunning.toString())));
            }
            if (StringUtils.isNotBlank(this.ipAddress)) {
                pairs.add(this.makePair("ips", this.ipAddress));
            }
            if (StringUtils.isNotBlank(this.vmHost)) {
                pairs.add(this.makePair("hostnames", this.vmHost));
            }
            if (StringUtils.isNotBlank(this.guestFullName)) {
                pairs.add(this.makePair("guest_os", this.guestFullName));
            }
            if (this.changeBlockTracking != null) {
                pairs.add(this.makePair("block_tracking", StringUtils.lowerCase(this.changeBlockTracking.toString())));
            }
            if (StringUtils.isNotBlank(this.version)) {
                pairs.add(this.makePair("version", this.version));
            }
            if (StringUtils.isNotBlank(this.uuid)) {
                pairs.add(this.makePair("uuid", this.uuid));
            }
            if (CollectionUtils.isNotEmpty(this.annotations)) {
                pairs.add(this.makePair("annotation", "[" + Joiner.on(',').join(this.annotations) + "]"));
            }
            if (CollectionUtils.isNotEmpty(this.dataStores)) {
                pairs.add(this.makePair("datastores", "[" + Joiner.on(',').join(this.dataStores) + "]"));
            }
            if (StringUtils.isNotBlank(this.folder)) {
                pairs.add(this.makePair("folder", this.folder));
            }
            if (StringUtils.isNotBlank(this.cluster)) {
                pairs.add(this.makePair("cluster", this.cluster));
            }
            if (this.clustered != null) {
                pairs.add(this.makePair("clustered", Boolean.TRUE.equals(this.clustered) ? "Yes" : "No"));
            }
            if (StringUtils.isNotBlank(this.vApp)) {
                pairs.add(this.makePair("vapp", this.vApp));
            }
            if (StringUtils.isNotBlank(this.resourcepool)) {
                pairs.add(this.makePair("resourcepool", this.resourcepool));
            }
            if (this.isVCenter) {
                pairs.add(this.makePair("apitype", "VirtualCenter"));
            }
            if (CollectionUtils.isNotEmpty(this.tags)) {
                pairs.add(this.makePair("tags", "[" + Joiner.on(',').join(this.tags) + "]"));
            }
            if (CollectionUtils.isNotEmpty(this.attributes) && CollectionUtils.isNotEmpty(values = this.attributes.stream().map(VMAttributesDto::toString).filter(StringUtils::isNotBlank).map(s -> "(" + s + ")").collect(Collectors.toList()))) {
                pairs.add(this.makePair("attributes", "[" + Joiner.on(',').join(values) + "]"));
            }
            if (this.exist != null) {
                pairs.add(this.makePair("exists", StringUtils.lowerCase(this.exist.toString())));
            }
            if (StringUtils.isNotBlank(this.description)) {
                pairs.add(this.makePair("description", this.description));
            }
            this.additionalInfo = CollectionUtils.isNotEmpty(pairs) ? pairs : null;
        }
        return this.additionalInfo;
    }

    @JsonIgnore
    private LisInfoKeyValuePair makePair(String key, String value) {
        assert (StringUtils.isNotBlank(key));
        LisInfoKeyValuePair p = new LisInfoKeyValuePair();
        p.setKey(key);
        p.setValue(value);
        return p;
    }

    public static VMDto fromFileDto(FileDto f) {
        VMDto v = null;
        if (f != null) {
            String description;
            String exists;
            String clustered;
            String resourcepool;
            String vapp;
            String cluster;
            String folder;
            String uuid;
            String version;
            String blocktracking;
            String guestOs;
            String guesttoolsrunning;
            String macaddress;
            PowerStateType p;
            String powerstate;
            String hostversion;
            String hostname;
            String ip;
            String datacenter;
            v = new VMDto();
            if (f.getTaskType() != null && f.getTaskType().getBackupType() != null) {
                v.setBackupType(f.getTaskType().getBackupType());
            }
            v.setType(f.getType());
            v.setName(StringUtils.indexOf((CharSequence)f.getName(), "/") != -1 ? StringUtils.substring(f.getName(), StringUtils.lastIndexOf((CharSequence)f.getName(), "/")) : f.getName());
            v.setPath(f.getPath());
            v.setServerName(f.getClientName());
            String vmname = f.getAdditionalInformation("vmname");
            if (StringUtils.isNotBlank(vmname)) {
                v.setName(vmname);
            }
            if (StringUtils.isNotBlank(datacenter = f.getAdditionalInformation("datacenter"))) {
                v.setDataCenter(datacenter);
            }
            if (StringUtils.isNotBlank(ip = f.getAdditionalInformation("ips"))) {
                if (StringUtils.startsWith(ip, "[")) {
                    ip = StringUtils.split(StringUtils.removeStart(ip, "["), ",", 2)[0];
                }
                v.setIpAddress(ip);
            }
            if (StringUtils.isNotBlank(hostname = f.getAdditionalInformation("hostnames"))) {
                if (StringUtils.startsWith(hostname, "[")) {
                    hostname = StringUtils.split(StringUtils.removeStart(hostname, "["), ",", 2)[0];
                }
                v.setVmHost(hostname);
            }
            if (StringUtils.isNotBlank(hostversion = f.getAdditionalInformation("hostversion"))) {
                v.setHostVersion(hostversion);
            }
            if (StringUtils.isNotBlank(powerstate = f.getAdditionalInformation("powerState")) && !PowerStateType.NONE.equals((Object)(p = PowerStateType.fromString(powerstate)))) {
                v.setPowerState(p);
            }
            if (StringUtils.isNotBlank(macaddress = f.getAdditionalInformation("mac_addresses"))) {
                if (StringUtils.startsWith(macaddress, "[")) {
                    macaddress = StringUtils.split(StringUtils.removeStart(macaddress, "["), ",", 2)[0];
                }
                v.setMacAddress(macaddress);
            }
            if (StringUtils.isNotBlank(guesttoolsrunning = f.getAdditionalInformation("guest_tools_running"))) {
                v.setGuestToolsRunning(Boolean.valueOf(guesttoolsrunning));
            }
            if (StringUtils.isNotBlank(guestOs = f.getAdditionalInformation("guest_os"))) {
                v.setGuestFullName(guestOs);
            }
            if (StringUtils.isNotBlank(blocktracking = f.getAdditionalInformation("block_tracking"))) {
                v.setChangeBlockTracking(Boolean.valueOf(blocktracking));
            }
            if (StringUtils.isNotBlank(version = f.getAdditionalInformation("version"))) {
                v.setVersion(version);
            }
            if (StringUtils.isNotBlank(uuid = f.getAdditionalInformation("uuid"))) {
                v.setUuid(uuid);
            }
            if (StringUtils.isNotBlank(folder = f.getAdditionalInformation("folder"))) {
                v.setFolder(folder);
            }
            if (StringUtils.isNotBlank(cluster = f.getAdditionalInformation("cluster"))) {
                v.setCluster(cluster);
            }
            if (StringUtils.isNotBlank(vapp = f.getAdditionalInformation("vapp"))) {
                v.setVApp(vapp);
            }
            if (StringUtils.isNotBlank(resourcepool = f.getAdditionalInformation("resourcepool"))) {
                v.setResourcepool(resourcepool);
            }
            if (StringUtils.isNotBlank(clustered = f.getAdditionalInformation("clustered"))) {
                v.setClustered(StringUtils.equalsIgnoreCase(clustered, "Yes"));
            }
            if (StringUtils.isNotBlank(exists = f.getAdditionalInformation("exists"))) {
                v.setExist(Boolean.valueOf(exists));
            }
            if (StringUtils.isNotBlank(description = f.getAdditionalInformation("description"))) {
                v.setDescription(description);
            }
        }
        return v;
    }

    @Override
    @JsonIgnore
    public String toString() {
        String typeStr;
        StringBuilder sb = new StringBuilder();
        sb.append("\"/");
        if (StringUtils.isNotBlank(this.serverName)) {
            sb.append(this.serverName);
            sb.append("/");
        }
        String string = typeStr = this.backupType != null ? this.backupType.getTypeName() : null;
        if (StringUtils.isBlank(typeStr)) {
            typeStr = "VMware vSphere";
        }
        sb.append(typeStr).append(":");
        if (StringUtils.isNotBlank(this.path)) {
            String p = StringUtils.removeEnd(this.path, "/" + this.name);
            p = StringUtils.removeStart(p, typeStr + ":");
            p = StringUtils.removeStart(p, "/" + typeStr + ":");
            sb.append(p).append("/").append(this.name);
        } else {
            sb.append(this.name);
        }
        sb.append("\" ").append(StringUtils.isNotBlank(this.type) ? this.type : "dv").append(" - - - - ");
        sb.append(this.size != null ? String.valueOf(this.size) : "0");
        sb.append(" - ");
        if (StringUtils.isNotBlank(this.serverName) && (BackupType.VM_WARE_VSPHERE.equals((Object)this.backupType) || this.backupType == null)) {
            sb.append(",vcenter=");
            sb.append(this.serverName);
        }
        if (StringUtils.isNotBlank(this.name)) {
            sb.append(this.backupType != null && !this.backupType.isVirtual() ? ",name=" : ",vmname=");
            sb.append(this.name);
        }
        if (StringUtils.isNotBlank(this.moRef)) {
            sb.append(",moref=");
            sb.append(this.moRef);
        }
        if (this.powerState != null && !PowerStateType.NONE.equals((Object)this.powerState)) {
            sb.append(",powerState=");
            sb.append((Object)this.powerState);
        }
        if (this.guestToolsRunning != null) {
            sb.append(",guest_tools_running=");
            sb.append(this.guestToolsRunning);
        }
        if (StringUtils.isNotBlank(this.ipAddress)) {
            sb.append(",ips=");
            sb.append(this.ipAddress);
            if (StringUtils.isNotBlank(this.vmHost)) {
                sb.append(",hostnames=");
                sb.append(this.vmHost);
            }
        }
        if (StringUtils.isNotBlank(this.macAddress)) {
            sb.append(",mac_addresses=");
            sb.append(this.macAddress);
        }
        if (StringUtils.isNotBlank(this.dataCenter)) {
            sb.append(",datacenter=");
            sb.append(this.dataCenter);
        }
        if (CollectionUtils.isNotEmpty(this.dataStores)) {
            sb.append(",datastores=[");
            Iterator<String> it = this.dataStores.iterator();
            while (it.hasNext()) {
                String dataStore = it.next();
                sb.append(dataStore);
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (CollectionUtils.isNotEmpty(this.networks)) {
            int pos = 0;
            for (String network : this.networks) {
                if (network == null) continue;
                sb.append(",network-");
                sb.append(pos);
                sb.append("=");
                sb.append(network);
                ++pos;
            }
        }
        if (StringUtils.isNotBlank(this.hostSystem)) {
            sb.append(",hostSystem=");
            sb.append(this.hostSystem);
        }
        if (StringUtils.isNotBlank(this.hostVersion)) {
            sb.append(",hostversion=");
            sb.append(this.hostVersion);
        }
        if (StringUtils.isNotBlank(this.cluster)) {
            sb.append(",cluster=");
            sb.append(this.cluster);
        }
        if (this.clustered != null) {
            sb.append(",clustered=");
            sb.append(Boolean.TRUE.equals(this.clustered) ? "Yes" : "No");
        }
        if (this.changeBlockTracking != null) {
            sb.append(",block_tracking=");
            sb.append(this.changeBlockTracking);
        }
        if (StringUtils.isNotBlank(this.version)) {
            sb.append(",version=");
            sb.append(this.version);
        }
        if (StringUtils.isNotBlank(this.guestFullName)) {
            sb.append(",guest_os=");
            sb.append(this.guestFullName);
        }
        if (StringUtils.isNotBlank(this.uuid)) {
            sb.append(",uuid=");
            sb.append(this.uuid);
        }
        if (StringUtils.isNotBlank(this.folder)) {
            sb.append(",folder=");
            sb.append(this.folder);
        }
        if (StringUtils.isNotBlank(this.vApp)) {
            sb.append(",vapp=");
            sb.append(this.vApp);
        } else if (StringUtils.isNotBlank(this.resourcepool)) {
            sb.append(",resourcepool=");
            sb.append(this.resourcepool);
        }
        if (StringUtils.isNotBlank(this.description)) {
            sb.append(",description=");
            sb.append(this.folder);
        }
        if (CollectionUtils.isNotEmpty(this.tasks)) {
            sb.append(",tasks=");
            sb.append(this.tasks);
        }
        if (CollectionUtils.isNotEmpty(this.annotations)) {
            sb.append(",annotation=");
            if (this.annotations.size() > 1) {
                Iterator<String> it = this.annotations.iterator();
                while (it.hasNext()) {
                    sb.append(it.next());
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
            }
        }
        if (CollectionUtils.isNotEmpty(this.attributes)) {
            sb.append(",attributes=[");
            Iterator<VMAttributesDto> it = this.attributes.iterator();
            while (it.hasNext()) {
                sb.append("(");
                VMAttributesDto vmAttributesDto = it.next();
                sb.append(vmAttributesDto.toString());
                sb.append(")");
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (CollectionUtils.isNotEmpty(this.tags)) {
            sb.append(",tags=[");
            Iterator<String> it = this.tags.iterator();
            while (it.hasNext()) {
                String tag = it.next();
                if (!StringUtils.isNotBlank(tag)) continue;
                sb.append(tag);
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public String getSource() {
        return this.backupType == null || BackupType.VM_WARE_VSPHERE.equals((Object)this.backupType) || BackupType.NONE.equals((Object)this.backupType) ? this.getDataCenter() + "/" + this.getName() : this.getName();
    }

    @Override
    public String getDisplayLabel() {
        return this.name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getServerName() {
        return this.serverName;
    }

    @Generated
    public String getVmClient() {
        return this.vmClient;
    }

    @Generated
    public boolean isVCenter() {
        return this.isVCenter;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getDataCenter() {
        return this.dataCenter;
    }

    @Generated
    public List<VMDKDto> getVmdkData() {
        return this.vmdkData;
    }

    @Generated
    public String getMoRef() {
        return this.moRef;
    }

    @Generated
    public PowerStateType getPowerState() {
        return this.powerState;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public String getVmHost() {
        return this.vmHost;
    }

    @Generated
    public String getMacAddress() {
        return this.macAddress;
    }

    @Generated
    public List<String> getNetworks() {
        return this.networks;
    }

    @Generated
    public String getHostSystem() {
        return this.hostSystem;
    }

    @Generated
    public String getCluster() {
        return this.cluster;
    }

    @Generated
    public Boolean getClustered() {
        return this.clustered;
    }

    @Generated
    public Boolean getChangeBlockTracking() {
        return this.changeBlockTracking;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getGuestFullName() {
        return this.guestFullName;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public Long getSize() {
        return this.size;
    }

    @Generated
    public boolean isResetCBTModeSoft() {
        return this.resetCBTModeSoft;
    }

    @Generated
    public Tasks getTask() {
        return this.task;
    }

    @Generated
    public List<String> getTasks() {
        return this.tasks;
    }

    @Generated
    public String getFolder() {
        return this.folder;
    }

    @Generated
    public Boolean getExist() {
        return this.exist;
    }

    @Generated
    public String getVApp() {
        return this.vApp;
    }

    @Generated
    public String getResourcepool() {
        return this.resourcepool;
    }

    @Generated
    public List<String> getAnnotations() {
        return this.annotations;
    }

    @Generated
    public List<VMAttributesDto> getAttributes() {
        return this.attributes;
    }

    @Generated
    public List<VMSnapshotDto> getSnapshots() {
        return this.snapshots;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public String getTaskGroupRef() {
        return this.taskGroupRef;
    }

    @Generated
    public String getHostVersion() {
        return this.hostVersion;
    }

    @Generated
    public List<String> getDataStores() {
        return this.dataStores;
    }

    @Generated
    public Boolean getGuestToolsRunning() {
        return this.guestToolsRunning;
    }

    @Generated
    public BackupType getBackupType() {
        return this.backupType;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getTaskGenClientName() {
        return this.taskGenClientName;
    }

    @Generated
    public String getTaskGenLocationName() {
        return this.taskGenLocationName;
    }

    @Generated
    public String getTaskGenOperSystemName() {
        return this.taskGenOperSystemName;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Generated
    public void setVmClient(String vmClient) {
        this.vmClient = vmClient;
    }

    @Generated
    public void setVCenter(boolean isVCenter) {
        this.isVCenter = isVCenter;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setDataCenter(String dataCenter) {
        this.dataCenter = dataCenter;
    }

    @Generated
    public void setVmdkData(List<VMDKDto> vmdkData) {
        this.vmdkData = vmdkData;
    }

    @Generated
    public void setMoRef(String moRef) {
        this.moRef = moRef;
    }

    @Generated
    public void setPowerState(PowerStateType powerState) {
        this.powerState = powerState;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setVmHost(String vmHost) {
        this.vmHost = vmHost;
    }

    @Generated
    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    @Generated
    public void setNetworks(List<String> networks) {
        this.networks = networks;
    }

    @Generated
    public void setHostSystem(String hostSystem) {
        this.hostSystem = hostSystem;
    }

    @Generated
    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    @Generated
    public void setClustered(Boolean clustered) {
        this.clustered = clustered;
    }

    @Generated
    public void setChangeBlockTracking(Boolean changeBlockTracking) {
        this.changeBlockTracking = changeBlockTracking;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setGuestFullName(String guestFullName) {
        this.guestFullName = guestFullName;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setSize(Long size) {
        this.size = size;
    }

    @Generated
    public void setResetCBTModeSoft(boolean resetCBTModeSoft) {
        this.resetCBTModeSoft = resetCBTModeSoft;
    }

    @Generated
    public void setTask(Tasks task) {
        this.task = task;
    }

    @Generated
    public void setTasks(List<String> tasks) {
        this.tasks = tasks;
    }

    @Generated
    public void setFolder(String folder) {
        this.folder = folder;
    }

    @Generated
    public void setExist(Boolean exist) {
        this.exist = exist;
    }

    @Generated
    public void setVApp(String vApp) {
        this.vApp = vApp;
    }

    @Generated
    public void setResourcepool(String resourcepool) {
        this.resourcepool = resourcepool;
    }

    @Generated
    public void setAnnotations(List<String> annotations) {
        this.annotations = annotations;
    }

    @Generated
    public void setAttributes(List<VMAttributesDto> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setSnapshots(List<VMSnapshotDto> snapshots) {
        this.snapshots = snapshots;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setTaskGroupRef(String taskGroupRef) {
        this.taskGroupRef = taskGroupRef;
    }

    @Generated
    public void setHostVersion(String hostVersion) {
        this.hostVersion = hostVersion;
    }

    @Generated
    public void setDataStores(List<String> dataStores) {
        this.dataStores = dataStores;
    }

    @Generated
    public void setGuestToolsRunning(Boolean guestToolsRunning) {
        this.guestToolsRunning = guestToolsRunning;
    }

    @Generated
    public void setBackupType(BackupType backupType) {
        this.backupType = backupType;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setTaskGenClientName(String taskGenClientName) {
        this.taskGenClientName = taskGenClientName;
    }

    @Generated
    public void setTaskGenLocationName(String taskGenLocationName) {
        this.taskGenLocationName = taskGenLocationName;
    }

    @Generated
    public void setTaskGenOperSystemName(String taskGenOperSystemName) {
        this.taskGenOperSystemName = taskGenOperSystemName;
    }

    @Generated
    public VMDto() {
    }
}

