/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.vms.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@Schema(description="VM attribute key-value pair.")
public class VMAttributesDto
extends AbstractSerializableObject
implements IDisplayLabelProvider {
    private static final long serialVersionUID = 8615315737096487730L;
    @Schema(description="The key of the attribute.", example="1")
    private int key;
    @Schema(description="The name of the attribute.", example="vm.name")
    private String name;
    @Schema(description="The value of the attribute.", example="vm-name")
    private String value;
    @Schema(description="The type of the attribute.", example="string")
    private String type;

    public VMAttributesDto(int key, String name, String value, String type) {
        this.key = key;
        this.name = name;
        this.value = value;
        this.type = type;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return StringUtils.isNotBlank(this.value) ? (String)(StringUtils.isNotBlank(this.name) ? StringUtils.trim(this.name) + " = " : "") + StringUtils.trim(this.value) : "";
    }

    @Override
    public String toString() {
        if (this.name == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("key=");
        sb.append(this.key);
        sb.append(", name=");
        sb.append(this.name);
        if (StringUtils.isNotBlank(this.value)) {
            sb.append(", value=");
            sb.append(this.value);
        }
        return sb.toString();
    }

    @Generated
    public int getKey() {
        return this.key;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setKey(int key) {
        this.key = key;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public VMAttributesDto() {
    }
}

