/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.utils;

import de.sep.sesam.common.text.TextUtils;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public final class ModelUtils {
    public static String getLabel(IDisplayLabelProvider o) {
        return o == null || StringUtils.isBlank(o.getDisplayLabel()) ? "" : o.getDisplayLabel();
    }

    public static void copyProperties(Object dest, Object origin) {
        assert (dest != null);
        assert (origin != null);
        try {
            PropertyUtils.copyProperties(dest, origin);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateProperties(Object dest, Object origin) {
        assert (dest != null);
        assert (origin != null);
        try {
            PropertyUtils.describe(origin).entrySet().stream().filter(e -> e.getValue() != null).filter(e -> !((String)e.getKey()).equals("class")).forEach(e -> {
                try {
                    Object v = e.getValue();
                    if (v instanceof String) {
                        v = TextUtils.normalizeSpecial((String)v);
                    }
                    PropertyUtils.setProperty(dest, (String)e.getKey(), v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updatePropertiesCli(Object dest, Object origin) {
        assert (dest != null);
        assert (origin != null);
        try {
            Set<Map.Entry<String, Object>> set = PropertyUtils.describe(dest).entrySet();
            for (Map.Entry<String, Object> entry : set) {
                Object value = null;
                try {
                    value = PropertyUtils.getProperty(origin, entry.getKey());
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    continue;
                }
                if (value == null) continue;
                try {
                    PropertyUtils.setProperty(dest, entry.getKey(), value);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

