/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;

public enum TasksSubType {
    BDA("_BDA"),
    CBS("_CBS"),
    CBT("_CBT"),
    CONFIG("_CONFIG"),
    IMAGE("_IMG"),
    LVM("_LVM"),
    MAIN("_MAIN"),
    NBD("_NBD"),
    RBD("_RBD"),
    RCT("_RCT"),
    SES("_SES"),
    VSS("_VSS"),
    VZD("_VZD"),
    ZFS("_ZFS"),
    ZFSBDA("_ZFSBDA"),
    NONE("_NONE");

    private final String subType;

    private TasksSubType(String subType) {
        this.subType = subType;
    }

    public static TasksSubType fromString(String s) {
        if (StringUtils.isBlank(s)) {
            return NONE;
        }
        s = StringUtils.trim(s);
        for (TasksSubType st : TasksSubType.values()) {
            if (!StringUtils.equalsIgnoreCase(s, st.subType) && !StringUtils.equalsIgnoreCase(s, st.name())) continue;
            return st;
        }
        return NONE;
    }

    @JsonIgnore
    public String getName() {
        if (this == NONE) {
            return null;
        }
        return this.subType;
    }

    @JsonIgnore
    public String toString() {
        if (this == NONE) {
            return "";
        }
        return this.subType;
    }
}

