/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import de.sep.sesam.model.OperSystems;
import de.sep.sesam.model.TaskTypes;
import de.sep.sesam.model.annotations.StringCapable;
import de.sep.sesam.model.core.AbstractSerializableObject;
import java.math.BigInteger;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@StringCapable
public class TaskTypesProtectionType
extends AbstractSerializableObject {
    private static final long serialVersionUID = -2791998030166866645L;
    private boolean extern = false;
    private boolean unix = false;
    private boolean windows = false;
    private boolean netware = false;
    private boolean ndmp = false;
    private boolean novellOESFlag = false;

    public TaskTypesProtectionType() {
    }

    public TaskTypesProtectionType(String taskTypeProtection) {
        this.setValue(taskTypeProtection);
    }

    public TaskTypesProtectionType(boolean isUnix, boolean isWindows, boolean isNetware, boolean isNDMP) {
        this.unix = isUnix;
        this.windows = isWindows;
        this.netware = isNetware;
        this.ndmp = isNDMP;
    }

    public TaskTypesProtectionType(OperSystems os) {
        assert (os != null);
        String platform = os.getPlatform();
        this.unix = "UNIX".equals(platform) || "LINUX".equals(platform);
        this.windows = "WINDOWS".equals(platform);
        this.netware = "NETWARE".equals(platform);
        this.ndmp = "NDMP".equals(platform);
        this.novellOESFlag = os.getType().hasNovellOESFlag();
        this.ndmp = "NDMP".equals(os.getPlatform());
    }

    private void setValue(String taskTypeProtection) {
        if (StringUtils.isBlank(taskTypeProtection)) {
            return;
        }
        byte[] raw = new BigInteger(taskTypeProtection.trim(), 16).toByteArray();
        for (int i = 0; i < raw.length; ++i) {
            if ((raw[i] & 1) == 1) {
                this.extern = true;
            }
            if ((raw[i] & 2) == 2) {
                this.unix = true;
            }
            if ((raw[i] & 4) == 4) {
                this.windows = true;
            }
            if ((raw[i] & 8) == 8) {
                this.netware = true;
            }
            if ((raw[i] & 0x10) != 16) continue;
            this.ndmp = true;
        }
    }

    public boolean isExtern() {
        return this.extern;
    }

    public boolean isUnix() {
        return this.unix;
    }

    public boolean isWindows() {
        return this.windows;
    }

    public boolean isNetware() {
        return this.netware;
    }

    public boolean isNDMP() {
        return this.ndmp;
    }

    @Override
    public String toString() {
        byte raw = 0;
        if (this.extern) {
            raw = (byte)(raw + 1);
        }
        if (this.unix) {
            raw = (byte)(raw + 2);
        }
        if (this.windows) {
            raw = (byte)(raw + 4);
        }
        if (this.netware) {
            raw = (byte)(raw + 8);
        }
        if (this.ndmp) {
            raw = (byte)(raw + 16);
        }
        return Byte.toString(raw);
    }

    public boolean isHandled(TaskTypesProtectionType other) {
        if (other.extern && this.extern) {
            return true;
        }
        if (other.unix && this.unix) {
            return true;
        }
        if (other.windows && this.windows) {
            return true;
        }
        if (other.netware && this.netware) {
            return true;
        }
        return other.ndmp && this.ndmp;
    }

    public boolean isHandled(TaskTypes resVal) {
        if (this.isHandled(resVal.getSuitablePlatform())) {
            return true;
        }
        return this.novellOESFlag && resVal.getName().equalsIgnoreCase("NetWare");
    }

    @Generated
    public boolean isNovellOESFlag() {
        return this.novellOESFlag;
    }

    @Generated
    public void setExtern(boolean extern) {
        this.extern = extern;
    }

    @Generated
    public void setUnix(boolean unix) {
        this.unix = unix;
    }

    @Generated
    public void setWindows(boolean windows) {
        this.windows = windows;
    }

    @Generated
    public void setNetware(boolean netware) {
        this.netware = netware;
    }

    @Generated
    public void setNdmp(boolean ndmp) {
        this.ndmp = ndmp;
    }

    @Generated
    public void setNovellOESFlag(boolean novellOESFlag) {
        this.novellOESFlag = novellOESFlag;
    }
}

