/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.type.Cfdi;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TaskTypesMissingCFDI
extends AbstractSerializableObject {
    private static final long serialVersionUID = 1745502360846684709L;
    Set<Cfdi> cfdi = new HashSet<Cfdi>();

    public TaskTypesMissingCFDI() {
    }

    public TaskTypesMissingCFDI(String fdiTypeString) {
        this.setValue(fdiTypeString);
    }

    public static TaskTypesMissingCFDI fromString(String s) {
        TaskTypesMissingCFDI migrationCfdiType = new TaskTypesMissingCFDI(s);
        return migrationCfdiType;
    }

    public void setValue(String value) {
        if (StringUtils.isNotEmpty(value)) {
            if (value.contains("c")) {
                this.cfdi.add(Cfdi.COPY);
            }
            if (value.contains("f")) {
                this.cfdi.add(Cfdi.FULL);
            }
            if (value.contains("d")) {
                this.cfdi.add(Cfdi.DIFF);
            }
            if (value.contains("i")) {
                this.cfdi.add(Cfdi.INCR);
            }
        }
    }

    public boolean isCopy() {
        return this.cfdi.contains(Cfdi.COPY);
    }

    public void setCopy(boolean copy) {
        if (copy) {
            this.cfdi.add(Cfdi.COPY);
        } else {
            this.cfdi.remove(Cfdi.COPY);
        }
    }

    public boolean isFull() {
        return this.cfdi.contains(Cfdi.FULL);
    }

    public void setFull(boolean full) {
        if (full) {
            this.cfdi.add(Cfdi.FULL);
        } else {
            this.cfdi.remove(Cfdi.FULL);
        }
    }

    public boolean isDiff() {
        return this.cfdi.contains(Cfdi.DIFF);
    }

    public void setDiff(boolean diff) {
        if (diff) {
            this.cfdi.add(Cfdi.DIFF);
        } else {
            this.cfdi.remove(Cfdi.DIFF);
        }
    }

    public boolean isIncr() {
        return this.cfdi.contains(Cfdi.INCR);
    }

    public void setIncr(boolean incr) {
        if (incr) {
            this.cfdi.add(Cfdi.INCR);
        } else {
            this.cfdi.remove(Cfdi.INCR);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isCopy()) {
            sb.append("c");
        }
        if (this.isFull()) {
            sb.append("f");
        }
        if (this.isDiff()) {
            sb.append("d");
        }
        if (this.isIncr()) {
            sb.append("i");
        }
        return sb.toString();
    }

    public Set<Cfdi> getSetCfdi() {
        return this.cfdi;
    }

    public List<Cfdi> buildListAllowedCfdi() {
        ArrayList<Cfdi> retVal = new ArrayList<Cfdi>();
        if (!this.cfdi.contains(Cfdi.COPY)) {
            retVal.add(Cfdi.COPY);
        }
        if (!this.cfdi.contains(Cfdi.FULL)) {
            retVal.add(Cfdi.FULL);
        }
        if (!this.cfdi.contains(Cfdi.DIFF)) {
            retVal.add(Cfdi.DIFF);
        }
        if (!this.cfdi.contains(Cfdi.INCR)) {
            retVal.add(Cfdi.INCR);
        }
        return retVal;
    }
}

