/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.annotations.StringCapable;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.type.SuppressFlag;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@StringCapable
public class SuppressFlags
extends AbstractSerializableObject {
    @JsonIgnore
    private static final long serialVersionUID = -1824039119775312405L;
    @JsonIgnore
    private final List<SuppressFlag> suppressFlags = new ArrayList<SuppressFlag>();

    public SuppressFlags(String suppressFlags) {
        this.setValue(suppressFlags);
    }

    public String getValue() {
        return this.toString();
    }

    public void setValue(String value) {
        this.suppressFlags.clear();
        if (StringUtils.isNotBlank(value)) {
            this.toSuppressFlagList(value);
        }
    }

    @JsonIgnore
    private void toSuppressFlagList(String value) {
        if (StringUtils.isNotBlank(value)) {
            for (char c : value.toCharArray()) {
                this.suppressFlags.add(SuppressFlag.fromChar(c));
            }
        }
    }

    public void addValue(SuppressFlag value) {
        if (value != null) {
            this.suppressFlags.add(value);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SuppressFlag flag : this.suppressFlags) {
            String str = flag.toString();
            if (sb.toString().contains(str)) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    @Generated
    public List<SuppressFlag> getSuppressFlags() {
        return this.suppressFlags;
    }

    @Generated
    public SuppressFlags() {
    }
}

