/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;

public enum SuppressFlag implements IDisplayLabelProvider
{
    ALL_EVENTS('A', "AllEvents"),
    BACKUP('B', "Backup"),
    MEDIA('M', "Media"),
    RESTORE('R', "Restore"),
    COMMAND('X', "Command"),
    MIGRATION_REPLICATION('C', "Migration/replication"),
    NONE(' ', "");

    private char fdiType;
    private String longType;

    private SuppressFlag(char fdiType, String l) {
        this.fdiType = fdiType;
        this.longType = l;
    }

    private SuppressFlag(String fdiType) {
        this.fdiType = (fdiType.length() > 0 ? Character.valueOf(fdiType.charAt(0)) : null).charValue();
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        return String.valueOf(this.fdiType);
    }

    public static SuppressFlag fromChar(char c) {
        c = Character.toUpperCase(c);
        for (SuppressFlag st : SuppressFlag.values()) {
            if (c != st.fdiType) continue;
            return st;
        }
        return NONE;
    }

    public static SuppressFlag fromString(String stype) {
        if (stype == null || stype.isEmpty()) {
            return NONE;
        }
        for (SuppressFlag st : SuppressFlag.values()) {
            if (!stype.equalsIgnoreCase(st.longType)) continue;
            return st;
        }
        return SuppressFlag.fromChar(stype.charAt(0));
    }

    @Override
    public String getDisplayLabel() {
        return this.longType;
    }
}

