/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import de.sep.sesam.model.type.MultiValue;
import org.apache.commons.lang3.StringUtils;

public enum StateType implements MultiValue
{
    IN_QUEUE(new String[]{"q", "Q", "4"}),
    ACTIVE(new String[]{"a", "A"}),
    SUCCESSFUL(new String[]{"0"}),
    INFO(new String[]{"1", "I"}),
    CANCELLED(new String[]{"3", "C", "c"}),
    ERROR(new String[]{"2", "X", "e"}),
    PARTIALLY_DELETED(new String[]{"d"}),
    TIMING(new String[]{"t"}),
    INITIALISATION(new String[]{"+"}),
    NONE(new String[]{"", "-", "?"}),
    UNUSED(new String[]{"z", "Z"}),
    WAITING(new String[]{"w", "W"}),
    SUPPRESSED(new String[]{"s"}),
    BLOCKED(new String[]{"b"}),
    DELETED(new String[]{"6"}),
    NONE_SELECTED(new String[]{"NONE_SELECTED"});

    private final String[] stateType;

    private StateType(String[] stateType) {
        this.stateType = stateType;
    }

    public static StateType fromString(String s) {
        if (StringUtils.isBlank(s)) {
            return NONE;
        }
        s = s.trim();
        for (StateType st : StateType.values()) {
            if (s.equalsIgnoreCase(st.name())) {
                return st;
            }
            for (String val : st.stateType) {
                if (!val.equals(s)) continue;
                return st;
            }
        }
        return NONE;
    }

    @Override
    public String[] getValues() {
        return this.stateType;
    }

    public String toString() {
        return this.stateType[0];
    }
}

