/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;

public enum SepPermissionType implements IDisplayLabelProvider
{
    SUPERUSER("superuser"),
    ADMIN("admin"),
    RESTORE_USER("restore"),
    OPERATOR("operator"),
    BACKUP_USER("backup"),
    NONE("");

    private final String permissionType;

    private SepPermissionType(String permissionType) {
        this.permissionType = permissionType;
    }

    public static SepPermissionType fromString(String s) {
        if (s == null) {
            return NONE;
        }
        for (SepPermissionType st : SepPermissionType.values()) {
            if (!st.permissionType.equalsIgnoreCase(s)) continue;
            return st;
        }
        return NONE;
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        return this.permissionType;
    }

    @Override
    public String getDisplayLabel() {
        return this.permissionType;
    }
}

