/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;

public enum ResultFdiType implements IDisplayLabelProvider
{
    COPY('C', "COPY"),
    FULL('F', "FULL"),
    DIFF('D', "DIFF"),
    INCR('I', "INC"),
    MEDIA('M', "MIGRATION"),
    NEWDAY('N', "NEWDAY"),
    STARTUP('S', "STARTUP"),
    EXECUTE('X', "EXECUTE"),
    NONE(' ', ""),
    NONE_SELECTED('-', "NONE_SELECTED");

    private char fdiType;
    private String longType;

    private ResultFdiType(char fdiType, String l) {
        this.fdiType = fdiType;
        this.longType = l;
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        return String.valueOf(this.fdiType);
    }

    public static ResultFdiType fromChar(char c) {
        for (ResultFdiType st : ResultFdiType.values()) {
            if (c != st.fdiType) continue;
            return st;
        }
        return NONE;
    }

    public static ResultFdiType fromString(String s) {
        if (s == null || s.isEmpty()) {
            return NONE;
        }
        s = s.trim();
        for (ResultFdiType st : ResultFdiType.values()) {
            if (!s.equalsIgnoreCase(st.longType)) continue;
            return st;
        }
        return ResultFdiType.fromChar(s.charAt(0));
    }

    @Override
    public String getDisplayLabel() {
        return this.longType;
    }
}

