/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;

public enum RestoreType implements IDisplayLabelProvider
{
    FULL('f'),
    SELECTIVE('s'),
    DISK_INFO('d'),
    NONE(' '),
    ATTACH('a'),
    MOUNT('m'),
    OTHER('o'),
    NO('0'),
    RECOVER('2'),
    RECOVER_START('6'),
    HOT('1'),
    HOT_RECOVER('3');

    private final char restoreType;

    private RestoreType(char dbtype) {
        this.restoreType = dbtype;
    }

    public static RestoreType fromChar(Character s) {
        if (s == null) {
            return NONE;
        }
        for (RestoreType st : RestoreType.values()) {
            if (st.restoreType != s.charValue()) continue;
            return st;
        }
        return NONE;
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        return String.valueOf(this.restoreType);
    }

    @Override
    public String getDisplayLabel() {
        return this.toString();
    }
}

