/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import de.sep.sesam.model.annotations.StringCapable;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.type.RestoreTransaction;
import de.sep.sesam.model.type.RestoreType;
import org.apache.commons.lang3.StringUtils;

@StringCapable
public class RestoreOptions
extends AbstractSerializableObject {
    private static final long serialVersionUID = -4991708041373290380L;
    private RestoreType mode;
    private RestoreTransaction transaction = RestoreTransaction.NONE;

    public RestoreOptions(String s) {
        if (StringUtils.isEmpty(s)) {
            this.setMode(RestoreType.NONE);
            return;
        }
        if (s.length() == 2) {
            this.setTransaction(RestoreTransaction.fromChar(Character.valueOf(s.charAt(1))));
        }
        this.setMode(RestoreType.fromChar(Character.valueOf(s.toLowerCase().charAt(0))));
    }

    public RestoreOptions() {
        this.mode = RestoreType.NONE;
    }

    public RestoreOptions(RestoreType mode, RestoreTransaction transaction) {
        this.mode = mode;
        this.setTransaction(transaction);
    }

    @Override
    public String toString() {
        if (this.getMode() == RestoreType.NONE) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        res.append(this.getMode().toString());
        if (this.getTransaction() != null && this.getTransaction() != RestoreTransaction.NONE) {
            res.append(this.getTransaction().toString());
        }
        return res.toString();
    }

    public RestoreType getMode() {
        return this.mode;
    }

    public void setMode(RestoreType mode) {
        this.mode = mode;
    }

    public RestoreTransaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(RestoreTransaction transaction) {
        this.transaction = transaction;
    }
}

