/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import org.apache.commons.lang3.StringUtils;

public enum RestoreMode implements IDisplayLabelProvider
{
    NEW_VERSION('v'),
    OVERWRITE('o'),
    OVERWRITE_NEWER('N'),
    OVERWRITE_OLDER('O'),
    NO_OVERWRITE('n'),
    ATTACH('a'),
    MOUNT('m'),
    MOUNT_SAVESET('M'),
    INSTANT_RECOVERY('I'),
    SANDBOX_RESTORE('S'),
    NONE(' ');

    private final char value;

    private RestoreMode(char value) {
        this.value = value;
    }

    public static RestoreMode fromChar(Character c) {
        if (c == null) {
            return NONE;
        }
        for (RestoreMode st : RestoreMode.values()) {
            if (c.charValue() != st.value) continue;
            return st;
        }
        return NONE;
    }

    public static RestoreMode fromString(String mode) {
        RestoreMode m = NONE;
        if (StringUtils.isNotBlank(mode)) {
            switch (StringUtils.upperCase(mode)) {
                case "NONE": 
                case "NEW_VERSION": 
                case "OVERWRITE": 
                case "OVERWRITE_NEWER": 
                case "OVERWRITE_OLDER": 
                case "NO_OVERWRITE": 
                case "ATTACH": 
                case "MOUNT": 
                case "MOUNT_SAVESET": {
                    m = RestoreMode.valueOf(mode);
                    break;
                }
                default: {
                    m = RestoreMode.fromChar(Character.valueOf(mode.toCharArray()[0]));
                }
            }
        }
        return m;
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        return String.valueOf(this.value);
    }

    @Override
    public String getDisplayLabel() {
        return this.toString();
    }
}

