/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.date.DateUtils;
import de.sep.sesam.common.date.HumanDate;
import de.sep.sesam.model.annotations.StringCapable;
import de.sep.sesam.model.core.AbstractSerializableObject;
import java.util.Date;
import lombok.Generated;

@StringCapable
public class RelativeDate
extends AbstractSerializableObject {
    @JsonIgnore
    private static final long serialVersionUID = 744027145897089203L;
    private Long relative;
    private Date absolute;

    public RelativeDate(Long relative) {
        assert (relative != null);
        this.relative = relative;
        this.absolute = null;
    }

    public RelativeDate(Date abs) {
        assert (abs != null);
        this.relative = null;
        this.absolute = abs;
    }

    public RelativeDate(String val) {
        assert (val != null);
        try {
            this.relative = Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            this.absolute = HumanDate.toDate(val);
        }
    }

    @JsonIgnore
    public Date getActualDate() {
        if (this.relative != null) {
            return new Date(System.currentTimeMillis() - this.relative);
        }
        return this.absolute;
    }

    @JsonIgnore
    public boolean isAbsoluteDate() {
        return this.absolute != null;
    }

    @JsonIgnore
    public boolean isRelativeDate() {
        return this.absolute == null;
    }

    @Override
    @JsonIgnore
    public String toString() {
        if (this.isAbsoluteDate()) {
            return DateUtils.dateToTableFormatStr(this.getAbsolute());
        }
        return this.getRelative() != null ? String.valueOf(this.getRelative()) : "";
    }

    @JsonIgnore
    public static RelativeDate fromString(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new RelativeDate(Long.valueOf(value));
        }
        catch (NumberFormatException e) {
            return new RelativeDate(HumanDate.toDate(value));
        }
    }

    @Generated
    public Long getRelative() {
        return this.relative;
    }

    @Generated
    public Date getAbsolute() {
        return this.absolute;
    }

    @Generated
    public void setRelative(Long relative) {
        this.relative = relative;
    }

    @Generated
    public void setAbsolute(Date absolute) {
        this.absolute = absolute;
    }

    @Generated
    public RelativeDate() {
    }
}

