/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.type.MultiValue;
import org.apache.commons.lang3.StringUtils;

public enum OnlineFlag implements MultiValue,
IDisplayLabelProvider
{
    HOT("1", "y", "hot"),
    COLD("0", "n", "cold"),
    WARM("2", "warm"),
    NONE("", " ");

    private String[] onlineType;

    private OnlineFlag(String ... type) {
        this.onlineType = type;
    }

    public static OnlineFlag fromString(String s) {
        if (StringUtils.isEmpty(s)) {
            return NONE;
        }
        s = s.trim();
        for (OnlineFlag st : OnlineFlag.values()) {
            for (String type : st.onlineType) {
                if (!s.equalsIgnoreCase(type)) continue;
                return st;
            }
        }
        return NONE;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        String s = "";
        if (HOT.equals(this)) {
            s = "hot";
        } else if (COLD.equals(this)) {
            s = "cold";
        } else if (WARM.equals(this)) {
            s = "warm";
        }
        return s;
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        return this.onlineType[0];
    }

    @Override
    public String[] getValues() {
        return this.onlineType;
    }
}

