/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;

public enum NotificationsAction {
    OPEN(10, "open"),
    CLOSE(20, "close"),
    UNDEFINED(0, "undefined");

    private String action;
    private int num;

    private NotificationsAction(int num, String action) {
        this.action = action;
        this.num = num;
    }

    public static NotificationsAction fromString(String s) {
        if (StringUtils.isEmpty(s)) {
            return UNDEFINED;
        }
        s = s.trim();
        for (NotificationsAction st : NotificationsAction.values()) {
            if (!st.action.equalsIgnoreCase(s) && !st.name().equalsIgnoreCase(s)) continue;
            return st;
        }
        try {
            int isev = Integer.parseInt(s);
            return NotificationsAction.fromNum(isev);
        }
        catch (Exception exception) {
            return UNDEFINED;
        }
    }

    public static NotificationsAction fromNum(Number num) {
        for (NotificationsAction entry : NotificationsAction.values()) {
            if (entry.num != num.intValue()) continue;
            return entry;
        }
        return null;
    }

    @JsonIgnore
    public String toString() {
        return this.action;
    }

    public String getTitle() {
        return this.action;
    }
}

