/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import org.apache.commons.lang3.StringUtils;

public enum NotificationsAcknowledged {
    OPEN("open", "Message is not acknowledged - is still no user interaction"),
    ACCEPTED("accepted", "Message accepted / acknowledged - A user has acknowledged the message."),
    LATER("later", "move up to XXX- the message will be processed later postponed until XXX, resubmission on XXX"),
    DISMISSED("dismissed", "rejected - the message is rejected. In general, the user does not want to deal with this any more."),
    RESOLVED("resolved", "ACCEPTED notification must be resolved");

    private String acknowledged;
    private String description;

    private NotificationsAcknowledged(String acknowledged, String description) {
        this.acknowledged = acknowledged;
        this.description = description;
    }

    public static NotificationsAcknowledged fromString(String s) {
        if (StringUtils.isBlank(s)) {
            return null;
        }
        for (NotificationsAcknowledged st : NotificationsAcknowledged.values()) {
            if (!StringUtils.equalsIgnoreCase(st.acknowledged, StringUtils.trim(s))) continue;
            return st;
        }
        return null;
    }

    public String toString() {
        return this.acknowledged;
    }

    public String getTitle() {
        return this.acknowledged;
    }

    public String getDescription() {
        return this.description;
    }
}

