/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

public enum NotificationSeverity {
    UNDEFINED(0, "undefined"),
    INFO(100, "info"),
    PROMOTION(200, "promotion"),
    RECOMMENDED(300, "recommended"),
    STRICTLY_RECOMMENDED(400, "strictly recommended", true),
    SECURITY(500, "security", true),
    SESAM_INFO(600, "sesam info"),
    IGNORE(700, "ignore"),
    WARNING(800, "warning"),
    ERROR(900, "error", true),
    CRITICAL(1000, "critical", true);

    private int num;
    private boolean highlight;
    private String title;

    private NotificationSeverity(int num, String title) {
        this.num = num;
        this.title = title;
    }

    private NotificationSeverity(int num, String title, boolean highlight) {
        this.num = num;
        this.title = title;
        this.highlight = highlight;
    }

    public static NotificationSeverity fromNum(Number num) {
        for (NotificationSeverity entry : NotificationSeverity.values()) {
            if (entry.num != num.intValue()) continue;
            return entry;
        }
        return null;
    }

    public static NotificationSeverity fromString(String s) {
        if (s == null) {
            return UNDEFINED;
        }
        s = s.trim();
        for (NotificationSeverity entry : NotificationSeverity.values()) {
            if (entry.name().equalsIgnoreCase(s)) {
                return entry;
            }
            if (!entry.getTitle().equalsIgnoreCase(s)) continue;
            return entry;
        }
        try {
            int isev = Integer.parseInt(s);
            return NotificationSeverity.fromNum(isev);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int toNum() {
        return this.num;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public String getTitle() {
        return this.title;
    }
}

