/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import de.sep.sesam.model.type.MultiValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public enum MediaReadCheckState implements MultiValue
{
    ACTION_FAILED("x", "X"),
    ACTIVE("a"),
    CANCELED("c", "C", "3"),
    ERROR("2", "E"),
    FAILED("f"),
    LOAD_FAILED("l"),
    NONE(""),
    NON_REQUESTED("n"),
    OK("o", "O", "0"),
    PAST_DUE("p"),
    PURGE("8"),
    QUEUED("q"),
    SUCCESSFUL("0", "S"),
    TIMEOUT("t"),
    UNREAD("u"),
    WARNING("1", "W");

    private final String[] readcheckState;

    private MediaReadCheckState(String ... readcheckState) {
        this.readcheckState = readcheckState;
    }

    public static MediaReadCheckState fromString(String s) {
        if (s == null) {
            return NONE;
        }
        for (MediaReadCheckState st : MediaReadCheckState.values()) {
            for (String val : st.readcheckState) {
                if (!val.equalsIgnoreCase(s)) continue;
                return st;
            }
        }
        return NONE;
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        return this.readcheckState[0];
    }

    @Override
    public String[] getValues() {
        return this.readcheckState;
    }

    public static List<MediaReadCheckState> fromString(Collection<String> extract) {
        ArrayList<MediaReadCheckState> result = new ArrayList<MediaReadCheckState>();
        for (String s : extract) {
            result.add(MediaReadCheckState.fromString(s));
        }
        return result;
    }
}

