/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import de.sep.sesam.common.text.I18n;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.type.PreferredMode;

public enum MatchingMode implements IDisplayLabelProvider
{
    NONE(PreferredMode.NONE, false, ""),
    ACTIVE_COPY_ONLY(PreferredMode.ACTIVE, false, I18n.get("EXCHANGE_ACTIVE_COPY_ONLY", new Object[0])),
    PASSIVE_COPY_ONLY(PreferredMode.PASSIVE, false, I18n.get("EXCHANGE_PASSIVE_COPY_ONLY", new Object[0])),
    ACTIVE_COPY_PREFERRED(PreferredMode.ACTIVE, true, I18n.get("EXCHANGE_ACTIVE_COPY_PREFFERED", new Object[0])),
    PASSIVE_COPY_PREFERRED(PreferredMode.PASSIVE, true, I18n.get("EXCHANGE_PASSIVE_COPY_PREFFERED", new Object[0]));

    private PreferredMode preferredMode;
    private Boolean allowOtherMode;
    private String label;

    private MatchingMode(PreferredMode preferredMode, Boolean allowOtherMode, String label) {
        this.preferredMode = preferredMode;
        this.allowOtherMode = allowOtherMode;
        this.label = label;
    }

    public PreferredMode getPreferredMode() {
        return this.preferredMode;
    }

    public Boolean getAllowOtherMode() {
        return this.allowOtherMode;
    }

    public String getLabel() {
        return this.label;
    }

    public static MatchingMode fromString(String s) {
        if (s == null) {
            return NONE;
        }
        s = s.trim();
        for (MatchingMode matchingMode : MatchingMode.values()) {
            if (!matchingMode.name().equalsIgnoreCase(s)) continue;
            return matchingMode;
        }
        return null;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public String getDisplayLabel() {
        return this.label;
    }

    public static MatchingMode fromValues(PreferredMode preferredMode, Boolean allowOtherMode) {
        switch (preferredMode) {
            case ACTIVE: {
                if (Boolean.TRUE.equals(allowOtherMode)) {
                    return ACTIVE_COPY_PREFERRED;
                }
                return ACTIVE_COPY_ONLY;
            }
            case NONE: {
                return NONE;
            }
            case PASSIVE: {
                if (Boolean.TRUE.equals(allowOtherMode)) {
                    return PASSIVE_COPY_PREFERRED;
                }
                return PASSIVE_COPY_ONLY;
            }
        }
        return NONE;
    }
}

