/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

public enum GuidLocationType {
    EQUAL(1, "equal"),
    LESSER(2, "lesser"),
    GREATER(3, "greater"),
    UNDEFINED(0, "undefined");

    private final String type;
    private final int num;

    private GuidLocationType(int num, String action) {
        this.type = action;
        this.num = num;
    }

    public static GuidLocationType fromString(String s) {
        if (s == null) {
            return UNDEFINED;
        }
        for (GuidLocationType st : GuidLocationType.values()) {
            if (!st.type.equalsIgnoreCase(s) && !st.name().equalsIgnoreCase(s)) continue;
            return st;
        }
        try {
            int isev = Integer.parseInt(s);
            return GuidLocationType.fromNum(isev);
        }
        catch (Exception exception) {
            return UNDEFINED;
        }
    }

    public static GuidLocationType fromNum(Number num) {
        for (GuidLocationType entry : GuidLocationType.values()) {
            if (entry.num != num.intValue()) continue;
            return entry;
        }
        return null;
    }

    public String toString() {
        if (this == UNDEFINED) {
            return "";
        }
        return this.type;
    }

    public String getTitle() {
        return this.type;
    }
}

