/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;

public enum EventType implements IDisplayLabelProvider
{
    NEWDAY('N', "NEWDAY"),
    NEWDAY_SCHEDULED('n', "NEWDAY_SCHEDULED"),
    EXECUTE('X', "EXECUTE"),
    EXECUTE_SCHEDULED('x', "EXECUTE_SCHEDULED"),
    BACKUP('B', "BACKUP"),
    BACKUP_SCHEDULED('b', "BACKUP_SCHEDULED"),
    GROUP('G', "GROUP"),
    GROUP_SCHEDULED('g', "GROUP_SCHEDULED"),
    STARTUP('S', "STARTUP"),
    STARTUP_SCHEDULED('s', "STARTUP_SCHEDULED"),
    MEDIA('M', "MEDIA"),
    MEDIA_SCHEDULED('m', "MEDIA_SCHEDULED"),
    RESTORE('R', "RESTORE"),
    RESTORE_SCHEDULED('r', "RESTORE_SCHEDULED"),
    MIGRATION('C', "MIGRATION"),
    COMMAND_SCHEDULED('c', "COMMAND_SCHEDULED"),
    DUMMY('.', ""),
    TASK(' ', "TASK"),
    NONE('-', "");

    private final char eventType;
    private final String longType;

    private EventType(char eventType, String l) {
        this.eventType = eventType;
        this.longType = l;
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        if (this == TASK) {
            return "";
        }
        return String.valueOf(this.eventType);
    }

    public static EventType fromChar(char c) {
        for (EventType st : EventType.values()) {
            if (st.eventType != c) continue;
            return st;
        }
        return NONE;
    }

    @Override
    public String getDisplayLabel() {
        return this.longType;
    }
}

