/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;

public enum Cfdi implements IDisplayLabelProvider
{
    COPY('C', "COPY"),
    FULL('F', "FULL"),
    DIFF('D', "DIFF"),
    INCR('I', "INCR"),
    NONE(' ', "");

    private char fdiType;
    private String longType;

    private Cfdi(char fdiType, String l) {
        this.fdiType = fdiType;
        this.longType = l;
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        return String.valueOf(this.fdiType);
    }

    public static Cfdi fromChar(char c) {
        c = Character.toUpperCase(c);
        for (Cfdi st : Cfdi.values()) {
            if (c != st.fdiType) continue;
            return st;
        }
        return NONE;
    }

    public static Cfdi fromString(String stype) {
        if (stype == null || stype.isEmpty()) {
            return NONE;
        }
        for (Cfdi st : Cfdi.values()) {
            if (!stype.equalsIgnoreCase(st.longType)) continue;
            return st;
        }
        return Cfdi.fromChar(stype.charAt(0));
    }

    @Override
    public String getDisplayLabel() {
        return this.longType;
    }
}

