/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;

public enum AllResultsType implements IDisplayLabelProvider
{
    RESTORE_RESULTS('R', "RESTORE"),
    MIGRATION_RESULTS('c', "MIGRATION"),
    REPLICATION_RESULTS('r', "REPLICATION"),
    MEDIA_RESULTS('m', "MEDIA"),
    COPY('C', "COPY"),
    FULL('F', "FULL"),
    DIFF('D', "DIFF"),
    INCR('I', "INC"),
    MEDIA('M', "MIGRATION"),
    NEWDAY('N', "NEWDAY"),
    STARTUP('S', "STARTUP"),
    EXECUTE('X', "EXECUTE"),
    NONE(' ', ""),
    NONE_SELECTED('-', "NONE_SELECTED");

    private final char eventType;
    private final String longType;

    private AllResultsType(char eventType, String l) {
        this.eventType = eventType;
        this.longType = l;
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        return String.valueOf(this.eventType);
    }

    @JsonIgnore
    public static AllResultsType fromChar(char c) {
        for (AllResultsType st : AllResultsType.values()) {
            if (st.eventType != c) continue;
            return st;
        }
        return NONE;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.longType;
    }
}

