/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.annotations.StringCapable;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.type.AllResultsType;
import de.sep.sesam.model.type.Cfdi;
import de.sep.sesam.model.type.CfdiType;
import de.sep.sesam.model.type.GroupMode;
import org.apache.commons.lang3.StringUtils;

@StringCapable
public class AllResultsFlag
extends AbstractSerializableObject {
    private static final long serialVersionUID = -1824039119775312405L;
    private GroupMode groupMode = null;
    private AllResultsType type = AllResultsType.NONE;

    public AllResultsFlag() {
    }

    public AllResultsFlag(AllResultsType type) {
        this.type = type;
    }

    public AllResultsFlag(GroupMode groupMode, AllResultsType type) {
        this.groupMode = groupMode;
        this.type = type;
    }

    public AllResultsFlag(String typeString) {
        if (StringUtils.isNotBlank(typeString)) {
            Character c = null;
            int pos = 0;
            if (typeString.length() > pos) {
                c = Character.valueOf(typeString.charAt(pos));
            }
            this.groupMode = GroupMode.fromChar(c);
            if (this.groupMode != null && typeString.length() > ++pos) {
                c = Character.valueOf(typeString.charAt(pos));
            }
            this.type = AllResultsType.fromChar(c.charValue());
        }
    }

    @Override
    @JsonIgnore
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.groupMode != null && this.groupMode != GroupMode.NONE) {
            sb.append(this.groupMode.toString());
        }
        if (this.type != null && this.type != AllResultsType.NONE) {
            sb.append(this.type.toString());
        }
        return sb.toString();
    }

    @JsonIgnore
    public String getDisplayLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.groupMode != null && this.groupMode != GroupMode.NONE) {
            sb.append(this.groupMode.toString());
        }
        if (this.type != null && this.type != AllResultsType.NONE) {
            sb.append(this.type.getDisplayLabel());
        } else {
            sb.append("_");
        }
        return sb.toString();
    }

    public GroupMode getGroupMode() {
        return this.groupMode;
    }

    public void setGroupMode(GroupMode genMode) {
        this.groupMode = genMode;
    }

    public AllResultsType getType() {
        return this.type;
    }

    public void setType(AllResultsType type) {
        this.type = type;
    }

    public CfdiType getCfdiType() {
        switch (this.type) {
            case COPY: {
                return new CfdiType(Cfdi.COPY);
            }
            case FULL: {
                return new CfdiType(Cfdi.FULL);
            }
            case INCR: {
                return new CfdiType(Cfdi.INCR);
            }
            case DIFF: {
                return new CfdiType(Cfdi.DIFF);
            }
        }
        return new CfdiType(Cfdi.NONE);
    }
}

