/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import org.apache.commons.lang3.StringUtils;

public enum AllEventType implements IDisplayLabelProvider
{
    COMMAND('X', "COMMAND"),
    MEDIA('M', "MEDIA"),
    MIGRATION('c', "MIGRATION"),
    REPLICATION('r', "REPLICATION"),
    NEWDAY('N', "NEWDAY"),
    RESTORE('R', "RESTORE"),
    STARTUP('S', "STARTUP"),
    TASKGROUP('G', "TASKGROUP"),
    TASK('B', "TASK"),
    COPY('C', "COPY"),
    FULL('F', "FULL"),
    DIFF('D', "DIFF"),
    INCR('I', "INC"),
    NONE(' ', "");

    private char type;
    private String longType;

    private AllEventType(char type, String longType) {
        this.type = type;
        this.longType = longType;
    }

    public static AllEventType fromString(String s) {
        if (s == null) {
            return NONE;
        }
        for (AllEventType val : AllEventType.values()) {
            if (!StringUtils.equals(String.valueOf(val.type), s) && !StringUtils.equals(val.longType, s)) continue;
            return val;
        }
        return NONE;
    }

    public static AllEventType fromChar(char c) {
        for (AllEventType st : AllEventType.values()) {
            if (st.type != c) continue;
            return st;
        }
        return NONE;
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        return String.valueOf(this.type);
    }

    @Override
    public String getDisplayLabel() {
        return this.longType;
    }
}

