/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.annotations.StringCapable;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.type.AllEventType;
import de.sep.sesam.model.type.Cfdi;
import de.sep.sesam.model.type.CfdiType;
import de.sep.sesam.model.type.GroupMode;
import org.apache.commons.lang3.StringUtils;

@StringCapable
public class AllEventFlag
extends AbstractSerializableObject {
    private static final long serialVersionUID = -1824039119775312405L;
    private GroupMode groupMode = null;
    private AllEventType type = AllEventType.NONE;

    public AllEventFlag() {
    }

    public AllEventFlag(AllEventType type) {
        this.type = type;
    }

    public AllEventFlag(GroupMode groupMode, AllEventType type) {
        this.groupMode = groupMode;
        this.type = type;
    }

    public AllEventFlag(String typeString) {
        if (StringUtils.isNotBlank(typeString)) {
            Character c = null;
            int pos = 0;
            if (typeString.length() > pos) {
                c = Character.valueOf(typeString.charAt(pos));
            }
            this.groupMode = GroupMode.fromChar(c);
            if (this.groupMode != null && typeString.length() > ++pos) {
                c = Character.valueOf(typeString.charAt(pos));
            }
            switch (typeString) {
                case "COMMAND": {
                    c = Character.valueOf('X');
                    break;
                }
                case "TASKGROUP": {
                    c = Character.valueOf('G');
                    break;
                }
                case "MIGRATION": {
                    c = Character.valueOf('c');
                    break;
                }
                case "REPLICATION": {
                    c = Character.valueOf('r');
                    break;
                }
                case "TASK": {
                    c = Character.valueOf('B');
                }
            }
            this.type = AllEventType.fromChar(c.charValue());
        }
    }

    @Override
    @JsonIgnore
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.groupMode != null && this.groupMode != GroupMode.NONE) {
            sb.append(this.groupMode);
        }
        if (this.type != null && this.type != AllEventType.NONE) {
            sb.append(this.type);
        }
        return sb.toString();
    }

    @JsonIgnore
    public String getDisplayLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.groupMode != null && this.groupMode != GroupMode.NONE) {
            sb.append(this.groupMode);
        }
        if (this.type != null && this.type != AllEventType.NONE) {
            sb.append(this.type.getDisplayLabel());
        } else {
            sb.append("_");
        }
        return sb.toString();
    }

    public GroupMode getGroupMode() {
        return this.groupMode;
    }

    public void setGroupMode(GroupMode genMode) {
        this.groupMode = genMode;
    }

    public AllEventType getType() {
        return this.type;
    }

    public void setType(AllEventType type) {
        this.type = type;
    }

    public CfdiType getCfdiType() {
        switch (this.type) {
            case COPY: {
                return new CfdiType(Cfdi.COPY);
            }
            case FULL: {
                return new CfdiType(Cfdi.FULL);
            }
            case INCR: {
                return new CfdiType(Cfdi.INCR);
            }
            case DIFF: {
                return new CfdiType(Cfdi.DIFF);
            }
        }
        return new CfdiType(Cfdi.NONE);
    }

    public boolean isTask() {
        return this.type == AllEventType.COPY || this.type == AllEventType.FULL || this.type == AllEventType.DIFF || this.type == AllEventType.INCR;
    }
}

