/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.type;

import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;

public enum AccessMode implements IDisplayLabelProvider
{
    RSH("RSH"),
    CTRL("CTRL"),
    PROXY("PROXY"),
    SSH("SSH"),
    SMSSH("SMSSH"),
    AGENTLESS("UNDEFINED"),
    VIRTUAL("VIRTUAL"),
    NONE("");

    private final String accessmode;

    private AccessMode(String accessmode) {
        this.accessmode = accessmode;
    }

    public static AccessMode fromString(String s) {
        if (s == null) {
            return NONE;
        }
        for (AccessMode st : AccessMode.values()) {
            if (!st.accessmode.equalsIgnoreCase(s)) continue;
            return st;
        }
        return NONE;
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        return this.accessmode;
    }

    @Override
    public String getDisplayLabel() {
        return this.accessmode;
    }
}

