/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.statistics.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.statistics.StatisticsSubtype;
import de.sep.sesam.model.statistics.StatisticsType;
import de.sep.sesam.model.statistics.interfaces.IStatisticResultContainer;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@Schema(description="Statistics service result DTO.")
public class StatisticsResultDto
extends AbstractSerializableObject
implements IStatisticResultContainer {
    private static final long serialVersionUID = -3271629953423200025L;
    private List<String> clients;
    private StatisticsType type;
    private StatisticsSubtype subtype;
    private List<IStatisticsResultItem> children;

    public StatisticsType getType() {
        return this.type;
    }

    public void setType(StatisticsType type) {
        this.type = type;
    }

    public StatisticsSubtype getSubtype() {
        return this.subtype;
    }

    public void setSubtype(StatisticsSubtype subtype) {
        this.subtype = subtype;
    }

    public List<String> getClients() {
        return this.clients;
    }

    public void setClients(List<String> clients) {
        this.clients = clients;
    }

    @Override
    public List<IStatisticsResultItem> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(IStatisticsResultItem item) {
        assert (item != null);
        if (this.children == null) {
            this.children = new ArrayList<IStatisticsResultItem>();
        }
        this.children.add(item);
    }

    @Override
    public void removeChild(IStatisticsResultItem item) {
        assert (item != null);
        if (this.children != null) {
            this.children.remove(item);
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
    }

    public static class StatisticResultItem
    extends AbstractSerializableObject
    implements IStatisticsResultItem {
        private static final long serialVersionUID = 6768264213535917802L;
        private final String id;
        private Map<String, Object> values;

        public StatisticResultItem() {
            this(null);
        }

        public StatisticResultItem(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Map<String, Object> getValues() {
            return this.values;
        }

        @Override
        @JsonIgnore
        public void putValue(String name, Object value) {
            assert (StringUtils.isNotBlank(name));
            assert (value != null);
            if (this.values == null) {
                this.values = new HashMap<String, Object>();
            }
            this.values.put(name, value);
        }

        @Override
        @JsonIgnore
        public void removeValue(String name) {
            assert (StringUtils.isNotBlank(name));
            if (this.values != null) {
                this.values.remove(name);
                if (this.values.isEmpty()) {
                    this.values = null;
                }
            }
        }

        @Override
        @JsonIgnore
        public Object getValue(String name) {
            assert (StringUtils.isNotBlank(name));
            if (this.values != null) {
                return this.values.get(name);
            }
            return null;
        }
    }

    public static class StatisticResultGroup
    extends AbstractSerializableObject
    implements IStatisticsResultItem,
    IStatisticResultContainer {
        private static final long serialVersionUID = -8986743052703931169L;
        @Schema(description="The group object ID.", example="1234567890")
        private final String id;
        @Schema(description="The group object type.", example="task")
        private final String type;
        @Schema(description="The list of child statistics. A child is either a statistics result group or a statistics result\nitem.", example="[{\"id\":\"1234567890\",\"type\":\"task\"},{\"id\":\"1234567891\",\"type\":\"task\"}]")
        private List<IStatisticsResultItem> children;
        @Schema(description="The map of values associated with the statistic result group. The values are associated with the statistics result item IDs.", example="{\"1234567890\":{\"name\":\"My task\"},\"1234567891\":{\"name\":\"My other task\"}}")
        private Map<String, Object> values;

        public StatisticResultGroup(String id, String type) {
            assert (StringUtils.isNotBlank(id));
            assert (StringUtils.isNotBlank(type));
            this.id = id;
            this.type = type;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        @Override
        public List<IStatisticsResultItem> getChildren() {
            return this.children;
        }

        @Override
        @JsonIgnore
        public void addChild(IStatisticsResultItem item) {
            assert (item != null);
            if (this.children == null) {
                this.children = new ArrayList<IStatisticsResultItem>();
            }
            this.children.add(item);
        }

        @Override
        @JsonIgnore
        public void removeChild(IStatisticsResultItem item) {
            assert (item != null);
            if (this.children != null) {
                this.children.remove(item);
                if (this.children.isEmpty()) {
                    this.children = null;
                }
            }
        }

        @Override
        public Map<String, Object> getValues() {
            return this.values;
        }

        @Override
        @JsonIgnore
        public void putValue(String name, Object value) {
            assert (StringUtils.isNotBlank(name));
            assert (value != null);
            if (this.values == null) {
                this.values = new HashMap<String, Object>();
            }
            this.values.put(name, value);
        }

        @Override
        @JsonIgnore
        public void removeValue(String name) {
            assert (StringUtils.isNotBlank(name));
            if (this.values != null) {
                this.values.remove(name);
                if (this.values.isEmpty()) {
                    this.values = null;
                }
            }
        }

        @Override
        @JsonIgnore
        public Object getValue(String name) {
            assert (StringUtils.isNotBlank(name));
            if (this.values != null) {
                return this.values.get(name);
            }
            return null;
        }
    }

    public static interface IStatisticsResultItem {
        public String getId();

        public Map<String, Object> getValues();

        public void putValue(String var1, Object var2);

        public void removeValue(String var1);

        public Object getValue(String var1);
    }
}

