/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.license.json;

import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.license.dto.GeneralStorageResultDto;
import de.sep.sesam.model.license.utils.LicenseUtils;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class StorageResults
extends AbstractSerializableObject {
    private static final long serialVersionUID = 4773838647914173075L;
    private int used;
    private int total;
    private Double totalGbUsed;
    private List<GeneralStorageResultDto> dataStores;

    public StorageResults(List<GeneralStorageResultDto> dataStores, String used, String total, boolean obfuscate) {
        if (CollectionUtils.isNotEmpty(dataStores)) {
            this.used = LicenseUtils.parseInt(used);
            this.total = LicenseUtils.parseInt(total);
            this.totalGbUsed = dataStores.stream().map(GeneralStorageResultDto::getCapacity).reduce(0.0, Double::sum);
            if (obfuscate) {
                dataStores.forEach(d -> d.setName("data_store-"));
                this.dataStores = dataStores;
            } else {
                this.dataStores = dataStores;
            }
        } else {
            this.dataStores = Collections.emptyList();
        }
    }

    @Generated
    public int getUsed() {
        return this.used;
    }

    @Generated
    public int getTotal() {
        return this.total;
    }

    @Generated
    public Double getTotalGbUsed() {
        return this.totalGbUsed;
    }

    @Generated
    public List<GeneralStorageResultDto> getDataStores() {
        return this.dataStores;
    }

    @Generated
    public StorageResults() {
    }
}

