/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.license.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.sep.sesam.model.license.json.NameServers;
import de.sep.sesam.model.license.utils.LicenseUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ServersVms {
    private int configured = 0;
    private int used;
    private int max;
    @JsonProperty(value="clients")
    private List<NameServers> virtualMachines;

    public ServersVms(List<String> vmsList, String used, String max, boolean obfuscate) {
        this.used = LicenseUtils.parseInt(used);
        this.max = LicenseUtils.parseInt(max);
        if (vmsList != null) {
            this.configured = vmsList.size();
            List<Object> vmsResult = new ArrayList();
            if (obfuscate) {
                vmsResult = Collections.nCopies(vmsList.size(), new NameServers("client-"));
            } else {
                for (String s : vmsList) {
                    if (StringUtils.isBlank(s)) continue;
                    vmsResult.add(new NameServers(s));
                }
            }
            this.virtualMachines = vmsResult;
        } else {
            this.virtualMachines = Collections.emptyList();
        }
    }

    @Generated
    public int getConfigured() {
        return this.configured;
    }

    @Generated
    public int getUsed() {
        return this.used;
    }

    @Generated
    public int getMax() {
        return this.max;
    }

    @Generated
    public List<NameServers> getVirtualMachines() {
        return this.virtualMachines;
    }

    @Generated
    public ServersVms() {
    }
}

