/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.license.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.sep.sesam.model.license.dto.AllServersDto;
import de.sep.sesam.model.license.json.NameTasksServers;
import de.sep.sesam.model.license.utils.LicenseUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;

public class ServersTask {
    private int configured = 0;
    private int used;
    private int total;
    private Integer microsoftExchange = null;
    private Integer microsoftExtension = null;
    @JsonProperty(value="clients")
    private List<NameTasksServers> servers;

    public ServersTask(List<AllServersDto> serversList, String used, String total, boolean obfuscateV2) {
        this.used = LicenseUtils.parseInt(used);
        this.total = LicenseUtils.parseInt(total);
        this.collectListInternal(serversList, obfuscateV2);
    }

    public ServersTask(List<AllServersDto> serversList, Map<String, Object> map, boolean obfuscateV2) {
        this.used = LicenseUtils.parseInt(LicenseUtils.mapGetNonNull(map, "exchange_nodes_used").toString());
        this.total = LicenseUtils.parseInt(LicenseUtils.mapGetNonNull(map, "exchange_nodes").toString());
        this.microsoftExchange = LicenseUtils.parseInt(LicenseUtils.mapGetNonNull(map, "msexchange_used").toString());
        this.microsoftExtension = LicenseUtils.parseInt(LicenseUtils.mapGetNonNull(map, "dag_member").toString());
        this.collectListInternal(serversList, obfuscateV2);
    }

    private void collectListInternal(List<AllServersDto> serversList, boolean obfuscate) {
        if (serversList != null && serversList.size() != 0) {
            TreeSet sourceSet = serversList.stream().map(AllServersDto::getSourceName).collect(Collectors.toCollection(TreeSet::new));
            this.configured = sourceSet.size();
            ArrayList<NameTasksServers> serversResult = new ArrayList<NameTasksServers>();
            sourceSet.forEach(name -> {
                List<String> tasks = serversList.stream().filter(s -> name.equals(s.getSourceName())).sorted(Comparator.comparing(AllServersDto::getTask)).map(AllServersDto::getTask).collect(Collectors.toList());
                if (obfuscate) {
                    tasks = Collections.nCopies(tasks.size(), "task-");
                }
                serversResult.add(new NameTasksServers(obfuscate ? "client-" : name, tasks));
            });
            this.servers = serversResult;
        } else {
            this.servers = Collections.emptyList();
        }
    }

    @Generated
    public int getConfigured() {
        return this.configured;
    }

    @Generated
    public int getUsed() {
        return this.used;
    }

    @Generated
    public int getTotal() {
        return this.total;
    }

    @Generated
    public Integer getMicrosoftExchange() {
        return this.microsoftExchange;
    }

    @Generated
    public Integer getMicrosoftExtension() {
        return this.microsoftExtension;
    }

    @Generated
    public List<NameTasksServers> getServers() {
        return this.servers;
    }

    @Generated
    public ServersTask() {
    }
}

